<?php
/**
 * Script para probar la conexión con Softland CORREGIDO
 * 
 * Este script usa el método correcto ObtenerStockPorBodega para probar la conexión
 */

// Mostrar todos los errores
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Aumentar el tiempo de ejecución
set_time_limit(60);

echo "<h2>Prueba de conexión con Softland (CORREGIDA)</h2>";
echo "<pre>";

// Configuración de Softland
$softland_api_url = 'http://201.236.190.215/ECOMMERCE/wsproducto.asmx';
$softland_username = 'STORE';
$softland_password = 'softland';
$softland_empresa = 'FIGARO';
$softland_codbode = '32';

echo "Configuración:\n";
echo "- URL: $softland_api_url\n";
echo "- Usuario: $softland_username\n";
echo "- Empresa: $softland_empresa\n";
echo "- Bodega: $softland_codbode\n\n";

// Producto de ejemplo para la prueba
$codigo_producto = "802114801";

// Crear solicitud SOAP para obtener stock por bodega (método correcto)
$xml_request = '<?xml version="1.0" encoding="utf-8"?>
<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
               xmlns:xsd="http://www.w3.org/2001/XMLSchema"
               xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
  <soap:Header>
    <AuthHeader xmlns="http://softland.cl/">
      <Username>' . $softland_username . '</Username>
      <Password>' . $softland_password . '</Password>
    </AuthHeader>
  </soap:Header>
  <soap:Body>
    <ObtenerStockPorBodega xmlns="http://softland.cl/">
      <codprod>' . $codigo_producto . '</codprod>
      <Empresa>' . $softland_empresa . '</Empresa>
      <Token></Token>
      <CodBode>' . $softland_codbode . '</CodBode>
      <Talla></Talla>
      <Color></Color>
    </ObtenerStockPorBodega>
  </soap:Body>
</soap:Envelope>';

echo "Enviando solicitud SOAP a Softland para el producto $codigo_producto...\n\n";

// Configurar cURL para la solicitud SOAP
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $softland_api_url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_request);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Content-Type: text/xml; charset=utf-8',
    'SOAPAction: "http://softland.cl/ObtenerStockPorBodega"', // SOAPAction CORREGIDO
    'Content-Length: ' . strlen($xml_request)
));

// Opción para ver información detallada de la solicitud
curl_setopt($ch, CURLOPT_VERBOSE, true);

// Guardar información detallada en un buffer
$verbose = fopen('php://temp', 'w+');
curl_setopt($ch, CURLOPT_STDERR, $verbose);

// Ejecutar la solicitud
$response = curl_exec($ch);
$curl_info = curl_getinfo($ch);

// Verificar errores
if (curl_errno($ch)) {
    echo "ERROR EN LA SOLICITUD CURL:\n";
    echo curl_error($ch) . "\n\n";
} else {
    echo "INFORMACIÓN DE LA SOLICITUD:\n";
    echo "- Código HTTP: " . $curl_info['http_code'] . "\n";
    echo "- Tiempo de respuesta: " . $curl_info['total_time'] . " segundos\n";
    echo "- Tamaño de la respuesta: " . $curl_info['size_download'] . " bytes\n\n";
    
    if ($curl_info['http_code'] == 200) {
        echo "CONEXIÓN EXITOSA ✅\n\n";
        
        // Intentar parsear la respuesta XML
        libxml_use_internal_errors(true);
        $xml = simplexml_load_string($response);
        
        if ($xml === false) {
            echo "ERROR AL PARSEAR XML:\n";
            foreach(libxml_get_errors() as $error) {
                echo "- " . $error->message . "\n";
            }
            libxml_clear_errors();
        } else {
            echo "RESPUESTA XML VÁLIDA ✅\n\n";
            
            // Extraer datos de stock
            try {
                $soap_ns = 'http://schemas.xmlsoap.org/soap/envelope/';
                $softland_ns = 'http://softland.cl/';
                
                $body = $xml->children($soap_ns)->Body;
                $response_node = $body->children($softland_ns)->ObtenerStockPorBodegaResponse;
                $result_node = $response_node->ObtenerStockPorBodegaResult;
                
                if (isset($result_node->stock->stock)) {
                    echo "DATOS DE STOCK ENCONTRADOS ✅\n\n";
                    
                    $stock_node = $result_node->stock->stock;
                    echo "DETALLES DEL STOCK:\n";
                    echo "- Código: " . $codigo_producto . "\n";
                    echo "- Bodega: " . (isset($stock_node->codbodega) ? $stock_node->codbodega : 'N/A') . "\n";
                    echo "- Stock Disponible: " . (isset($stock_node->disponible) ? $stock_node->disponible : 'N/A') . "\n";
                } else {
                    echo "NO SE ENCONTRARON DATOS DE STOCK EN LA RESPUESTA\n";
                }
            } catch (Exception $e) {
                echo "ERROR AL PROCESAR LA RESPUESTA: " . $e->getMessage() . "\n";
            }
        }
    } else {
        echo "ERROR EN LA CONEXIÓN ❌\n";
        echo "La solicitud recibió un error HTTP " . $curl_info['http_code'] . "\n\n";
    }
}

// Obtener información detallada de cURL para diagnóstico
rewind($verbose);
$verboseLog = stream_get_contents($verbose);
fclose($verbose);

echo "\nDETALLES TÉCNICOS DE LA CONEXIÓN:\n";
echo $verboseLog;

// Mostrar los primeros 500 caracteres de la respuesta para diagnóstico
echo "\nPRIMEROS 500 CARACTERES DE LA RESPUESTA:\n";
echo substr($response, 0, 500) . "...\n";

// Cerrar cURL
curl_close($ch);

echo "</pre>";
echo "<hr>";
echo "<p><strong>Conclusión:</strong> Si esta prueba muestra \"CONEXIÓN EXITOSA ✅\", entonces el servicio Softland está funcionando correctamente con estas credenciales.</p>";
?>