<?php
/**
 * Archivo de verificación de permisos
 * Este archivo debe ser incluido al inicio de cada página que requiera permisos específicos
 */

// Verificar si ya hay una sesión activa
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Obtener el nombre del archivo actual
$archivo_actual = basename($_SERVER['PHP_SELF']);
$accion = $_GET['action'] ?? 'ver';

// Mapeo de archivos a módulos
$modulos = [
    'rendiciones.php' => 'rendiciones',
    'ordenes_compra.php' => 'ordenes_compra',
    'usuarios.php' => 'usuarios',
    'maquinas.php' => 'maquinas',
    'repuestos.php' => 'repuestos',
    'categorias.php' => 'categorias',
    'proveedores.php' => 'proveedores',
    'devoluciones.php' => 'devoluciones'
];

// Verificar si el archivo actual requiere permisos específicos
if (isset($modulos[$archivo_actual])) {
    $modulo = $modulos[$archivo_actual];
    
    // Verificar permisos según la acción
    switch ($accion) {
        case 'new':
            verificarPermisosAccion($modulo, 'crear');
            break;
        case 'edit':
            verificarPermisosAccion($modulo, 'editar');
            break;
        case 'delete':
            verificarPermisosAccion($modulo, 'eliminar');
            break;
        case 'approve':
            verificarPermisosAccion($modulo, 'aprobar');
            break;
        default:
            verificarPermisosAccion($modulo, 'ver');
    }
}

// Verificar acceso a la URL actual
if (!puedeAccederURL($_SERVER['PHP_SELF'])) {
    redirigirConMensaje('dashboard.php', 'No tiene permisos para acceder a esta sección', 'danger');
} 