<?php
require_once 'includes/config.php';

// Agregar logging
error_log("Iniciando get_repuestos.php");

header('Content-Type: application/json');

try {
    $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass, $db_options);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $query = isset($_GET['query']) ? trim($_GET['query']) : '';
    $maquina_id = isset($_GET['maquina_id']) ? intval($_GET['maquina_id']) : 0;
    
    error_log("Query: " . $query);
    error_log("Maquina ID: " . $maquina_id);
    
    // Preparar la consulta base
    $sql_base = "
        SELECT DISTINCT r.id, r.codigo, r.nombre, r.stock, r.activo, r.numero_pieza
        FROM repuestos r
    ";
    
    $params = [];
    
    // Si hay máquina_id, unir con la tabla maquina_repuesto
    if ($maquina_id > 0) {
        $sql_base .= "
            INNER JOIN maquina_repuesto mr ON r.id = mr.repuesto_id
            WHERE r.activo = 1 AND mr.maquina_id = :maquina_id
        ";
        $params[':maquina_id'] = $maquina_id;
        
        if (!empty($query)) {
            $sql_base .= " AND (r.codigo LIKE :query OR r.nombre LIKE :query OR r.numero_pieza LIKE :query)";
            $params[':query'] = '%' . $query . '%';
        }
    } else {
        // Si no hay máquina_id, buscar en todos los repuestos
        $sql_base .= " WHERE r.activo = 1";
        
        if (!empty($query)) {
            $sql_base .= " AND (r.codigo LIKE :query OR r.nombre LIKE :query OR r.numero_pieza LIKE :query)";
            $params[':query'] = '%' . $query . '%';
        }
    }
    
    $sql_base .= " ORDER BY r.codigo LIMIT 50";
    
    $stmt = $conn->prepare($sql_base);
    foreach ($params as $param => $value) {
        $stmt->bindValue($param, $value);
    }
    $stmt->execute();
    
    $repuestos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Marcar como disponibles los que tienen stock
    foreach ($repuestos as &$repuesto) {
        $repuesto['disponible'] = ($repuesto['activo'] == 1 && $repuesto['stock'] > 0) ? 1 : 0;
    }
    
    error_log("Repuestos encontrados: " . count($repuestos));
    
    echo json_encode([
        'success' => true,
        'repuestos' => $repuestos
    ]);
    
} catch (Exception $e) {
    error_log("Error en get_repuestos.php: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
} 