<?php
/**
 * Página de errores personalizada para SisRendiciones
 * Muestra un mensaje de error amigable con opciones para regresar
 */

// Inicializar sesión para manejar mensajes flash
session_start();

// Obtener tipo de error y mensaje si existe
$error_type = isset($_GET['type']) ? $_GET['type'] : 'general';
$error_code = isset($_GET['code']) ? $_GET['code'] : 500;
$error_message = isset($_GET['message']) ? $_GET['message'] : 'Ha ocurrido un error inesperado.';

// Determinar título según error
$page_title = 'Error';
switch ($error_type) {
    case '404':
        $page_title = 'Página no encontrada';
        $error_title = 'Oops! Página no encontrada';
        $error_subtitle = 'La página que estás buscando no existe o ha sido movida.';
        break;
    case 'access':
        $page_title = 'Acceso denegado';
        $error_title = 'Acceso denegado';
        $error_subtitle = 'No tienes permisos para acceder a esta sección.';
        break;
    case 'database':
        $page_title = 'Error de base de datos';
        $error_title = 'Error de base de datos';
        $error_subtitle = 'Ha ocurrido un problema al conectar con la base de datos.';
        break;
    default:
        $page_title = 'Error';
        $error_title = 'Ha ocurrido un error';
        $error_subtitle = 'Lo sentimos, algo no salió como esperábamos.';
}

// Obtener botón de redirección dependiendo del tipo de error
$back_url = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : 'dashboard.php';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> | SisRendiciones</title>
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <style>
        :root {
            --primary: #1e88e5;
            --primary-light: #6ab7ff;
            --primary-dark: #005cb2;
            --secondary: #26a69a;
            --success: #66bb6a;
            --warning: #ffa726;
            --danger: #ef5350;
            --light: #f5f5f5;
            --dark: #263238;
            --gray: #607d8b;
            --white: #ffffff;
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            --border-radius: 8px;
            --transition: all 0.3s ease;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: var(--light);
            color: var(--dark);
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            padding: 20px;
        }
        
        .error-container {
            max-width: 600px;
            margin: auto;
            text-align: center;
            padding: 40px 20px;
            background-color: var(--white);
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            animation: fadeInUp 0.5s ease;
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .error-icon {
            font-size: 120px;
            margin-bottom: 20px;
            display: block;
            color: var(--primary);
        }
        
        .error-emoji {
            font-size: 100px;
            margin-bottom: 20px;
        }
        
        .error-title {
            font-size: 28px;
            font-weight: 600;
            margin-bottom: 10px;
            color: var(--dark);
        }
        
        .error-subtitle {
            font-size: 16px;
            color: var(--gray);
            margin-bottom: 25px;
        }
        
        .error-message {
            padding: 15px;
            background-color: rgba(30, 136, 229, 0.1);
            border-radius: var(--border-radius);
            margin-bottom: 25px;
            color: var(--primary-dark);
            font-size: 14px;
        }
        
        .btn {
            padding: 12px 24px;
            border-radius: var(--border-radius);
            border: none;
            cursor: pointer;
            font-size: 16px;
            font-weight: 500;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            text-decoration: none;
            margin: 0 5px;
        }
        
        .btn-primary {
            background-color: var(--primary);
            color: var(--white);
        }
        
        .btn-primary:hover {
            background-color: var(--primary-dark);
        }
        
        .btn-outline {
            background-color: transparent;
            color: var(--primary);
            border: 1px solid var(--primary);
        }
        
        .btn-outline:hover {
            background-color: rgba(30, 136, 229, 0.1);
        }
        
        .btn i {
            margin-right: 8px;
        }
        
        .buttons {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 10px;
        }
        
        .footer {
            margin-top: auto;
            text-align: center;
            padding: 20px 0;
            color: var(--gray);
            font-size: 14px;
        }
        
        /* Responsive adjustments */
        @media (max-width: 576px) {
            .error-container {
                padding: 30px 15px;
            }
            
            .error-title {
                font-size: 24px;
            }
            
            .error-icon {
                font-size: 80px;
            }
            
            .buttons {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
                margin: 5px 0;
            }
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-emoji">😢</div>
        <h1 class="error-title"><?php echo $error_title; ?></h1>
        <p class="error-subtitle"><?php echo $error_subtitle; ?></p>
        
        <?php if ($error_message): ?>
        <div class="error-message">
            <?php echo $error_message; ?>
        </div>
        <?php endif; ?>
        
        <div class="buttons">
            <a href="<?php echo $back_url; ?>" class="btn btn-outline">
                <i class="material-icons">arrow_back</i> Volver
            </a>
            <a href="dashboard.php" class="btn btn-primary">
                <i class="material-icons">dashboard</i> Ir al Dashboard
            </a>
        </div>
    </div>
    
    <div class="footer">
        <p>&copy; <?php echo date('Y'); ?> SisRendiciones - Todos los derechos reservados</p>
    </div>
</body>
</html>