<?php
require_once 'includes/config.php';
require_once 'includes/functions.php';

// Verificar que se proporcionó un archivo
if (!isset($_GET['file']) || empty($_GET['file'])) {
    header('HTTP/1.0 400 Bad Request');
    die('Solicitud inválida');
}

$file = $_GET['file'];

// Validar que el archivo solicitado está dentro de las carpetas permitidas
$allowed_paths = [
    'upload/rendicion_',
    'upload/devolucion_',
    'upload/orden_',
    'uploads/rendicion_',
    'uploads/devolucion_',
    'uploads/orden_'
];

$is_valid_path = false;
foreach ($allowed_paths as $path) {
    if (strpos($file, $path) === 0) {
        $is_valid_path = true;
        break;
    }
}

if (!$is_valid_path) {
    header('HTTP/1.0 403 Forbidden');
    die('Ruta de archivo no permitida');
}

// Construir la ruta completa del archivo
$file_path = __DIR__ . '/' . $file;

// Verificar que el archivo existe
if (!file_exists($file_path)) {
    error_log("Archivo no encontrado: " . $file_path);
    header('HTTP/1.0 404 Not Found');
    die('Archivo no encontrado');
}

// Verificar permisos de acceso
protegerArchivo($file);

// Obtener el tipo MIME del archivo
$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mime_type = finfo_file($finfo, $file_path);
finfo_close($finfo);

// Configurar headers para la descarga
header('Content-Type: ' . $mime_type);
header('Content-Disposition: attachment; filename="' . basename($file_path) . '"');
header('Content-Length: ' . filesize($file_path));
header('Cache-Control: no-cache, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

// Enviar el archivo
readfile($file_path);
exit; 