</main>
    </div>

    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.7.0/chart.min.js"></script>
    <script>
        // Funcionalidad para mostrar/ocultar sidebar en dispositivos móviles
        document.addEventListener('DOMContentLoaded', function() {
            const toggleButton = document.querySelector('.toggle-sidebar');
            const sidebar = document.querySelector('.sidebar');
            
            if (toggleButton && sidebar) {
                toggleButton.addEventListener('click', function() {
                    sidebar.classList.toggle('active');
                    
                    // Cambiar el ícono según el estado
                    const icon = toggleButton.querySelector('i');
                    if (sidebar.classList.contains('active')) {
                        icon.textContent = 'close';
                    } else {
                        icon.textContent = 'menu';
                    }
                });
                
                // Cerrar sidebar al hacer clic en un enlace (en móviles)
                const menuItems = document.querySelectorAll('.menu-item');
                menuItems.forEach(item => {
                    item.addEventListener('click', function() {
                        if (window.innerWidth <= 768) {
                            sidebar.classList.remove('active');
                            toggleButton.querySelector('i').textContent = 'menu';
                        }
                    });
                });
            }
            
            // Inicializar tooltips, popovers y otros componentes JS si es necesario
        });
        
        // Función para confirmar acciones destructivas
        function confirmarAccion(mensaje) {
            return confirm(mensaje || '¿Está seguro de realizar esta acción?');
        }
        
        // Función para formatear números como moneda
        function formatoMoneda(valor) {
            return '$' + parseFloat(valor).toLocaleString('es-CL');
        }
        
        // Auto-cerrar alertas después de 5 segundos
        setTimeout(function() {
            const alertas = document.querySelectorAll('.alert');
            alertas.forEach(function(alerta) {
                alerta.style.opacity = '0';
                alerta.style.transition = 'opacity 0.5s';
                setTimeout(function() {
                    alerta.style.display = 'none';
                }, 500);
            });
        }, 5000);
    </script>
    
    <?php if (isset($page_scripts)): ?>
    <!-- Scripts específicos de la página -->
    <?php echo $page_scripts; ?>
    <?php endif; ?>
</body>
</html>