<?php
/**
 * get_serie.php
 * Obtiene información de una serie específica de máquina
 * Devuelve los datos en formato JSON
 */

require_once 'includes/config.php';
require_once 'includes/functions.php';

verificarSesion();

if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'ID de serie no proporcionado']);
    exit;
}

$id = intval($_GET['id']);

try {
    $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass, $db_options);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $stmt = $conn->prepare("
        SELECT sm.*, p.nombre as proveedor_nombre, p.rut as proveedor_rut
        FROM series_maquinas sm
        LEFT JOIN proveedores p ON sm.proveedor_id = p.id
        WHERE sm.id = :id
    ");
    $stmt->bindParam(':id', $id);
    $stmt->execute();
    
    $serie = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($serie) {
        echo json_encode(['success' => true, 'serie' => $serie]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Serie no encontrada']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}