<?php
require_once 'includes/config.php';
header('Content-Type: application/json');

try {
    // Verificar que las variables están definidas
    if (!isset($db_host) || !isset($db_name) || !isset($db_user) || !isset($db_pass)) {
        throw new Exception('Las variables de la base de datos no están definidas correctamente');
    }

    // Intentar la conexión con manejo de errores detallado
    try {
        $dsn = "mysql:host=" . $db_host . ";dbname=" . $db_name;
        $pdo = new PDO($dsn, $db_user, $db_pass, array(
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8",
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ));
    } catch (PDOException $e) {
        throw new Exception('Error de conexión a la base de datos: ' . $e->getMessage());
    }

    $query = isset($_GET['query']) ? trim($_GET['query']) : '';
    $maquina_id = isset($_GET['maquina_id']) ? trim($_GET['maquina_id']) : '';
    $serie_id = isset($_GET['serie_id']) ? trim($_GET['serie_id']) : '';

    // Log de parámetros recibidos
    error_log("Búsqueda de repuestos - Query: " . $query . ", Maquina ID: " . $maquina_id . ", Serie ID: " . $serie_id);

    // Obtener los repuestos asociados a la máquina
    $sql = "SELECT DISTINCT r.* FROM repuestos r ";
    $params = array();

    if ($maquina_id) {
        $sql .= "INNER JOIN maquina_repuesto mr ON r.id = mr.repuesto_id 
                 WHERE mr.maquina_id = :maquina_id AND r.activo = 1 ";
        $params[':maquina_id'] = $maquina_id;

        if ($query) {
            $sql .= "AND (r.codigo LIKE :query OR r.nombre LIKE :query_nombre OR r.numero_pieza LIKE :query_pieza) ";
            $params[':query'] = "%$query%";
            $params[':query_nombre'] = "%$query%";
            $params[':query_pieza'] = "%$query%";
        }
    } else {
        $sql .= "WHERE r.activo = 1 ";
        if ($query) {
            $sql .= "AND (r.codigo LIKE :query OR r.nombre LIKE :query_nombre OR r.numero_pieza LIKE :query_pieza) ";
            $params[':query'] = "%$query%";
            $params[':query_nombre'] = "%$query%";
            $params[':query_pieza'] = "%$query%";
        }
    }

    $sql .= "ORDER BY r.codigo LIMIT 50";
    
    // Log de la consulta SQL
    error_log("SQL Query: " . $sql);
    error_log("Params: " . print_r($params, true));

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $repuestos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Información de la serie y cliente solo si se proporciona serie_id
    $serie_info = null;
    if ($serie_id) {
        $sqlSerie = "SELECT sm.*, c.nombre as cliente_nombre, c.rut as cliente_rut 
                     FROM series_maquinas sm 
                     LEFT JOIN clientes c ON sm.cliente_id = c.id 
                     WHERE sm.id = :serie_id";
        $stmtSerie = $pdo->prepare($sqlSerie);
        $stmtSerie->execute([':serie_id' => $serie_id]);
        $serie_info = $stmtSerie->fetch(PDO::FETCH_ASSOC);
    }

    // Log del número de resultados
    error_log("Número de repuestos encontrados: " . count($repuestos));

    echo json_encode([
        'success' => true,
        'repuestos' => $repuestos,
        'query' => $query,
        'maquina_id' => $maquina_id,
        'serie_id' => $serie_id,
        'serie_info' => $serie_info
    ]);

} catch (PDOException $e) {
    error_log("Error PDO: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error en la base de datos: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    error_log("Error general: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error general: ' . $e->getMessage()
    ]);
} 