<?php
/**
 * Header y sidebar compartido para todas las páginas del sistema
 * Versión optimizada con mejoras de rendimiento y accesibilidad
 */

// Verificar sesión activa
require_once __DIR__ . '/functions.php';
verificarSesion();

// Obtener datos del usuario actual
$user_id = $_SESSION['user_id'] ?? 0;
$user_nombre = $_SESSION['user_nombre'] ?? '';
$user_apellido = $_SESSION['user_apellido'] ?? '';
$user_rol = $_SESSION['user_rol'] ?? '';
$user_iniciales = mb_substr($user_nombre, 0, 1, 'UTF-8') . mb_substr($user_apellido, 0, 1, 'UTF-8');

// Determinar la página actual para marcar el menú activo
$current_page = basename($_SERVER['PHP_SELF']);

// Determinar roles y permisos
$is_admin = ($user_rol === 'admin' || $user_rol === 'super_admin');
$is_super_admin = ($user_rol === 'super_admin');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Sistema de Gestión de Rendiciones y Órdenes de Compra">
    <title><?php echo htmlspecialchars($page_title ?? 'Gestión de Documentos'); ?></title>
    <!-- Favicon -->
    <link rel="icon" href="https://cdn-icons-png.flaticon.com/512/3502/3502688.png" type="image/png">
    <link rel="shortcut icon" href="https://cdn-icons-png.flaticon.com/512/3502/3502688.png" type="image/png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://cdnjs.cloudflare.com">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <style>
        :root {
            --primary: #1e88e5;
            --primary-light: #6ab7ff;
            --primary-dark: #005cb2;
            --secondary: #26a69a;
            --success: #66bb6a;
            --warning: #ffa726;
            --danger: #ef5350;
            --light: #f5f5f5;
            --dark: #263238;
            --gray: #607d8b;
            --white: #ffffff;
            --shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            --shadow-hover: 0 4px 8px rgba(0, 0, 0, 0.15);
            --border-radius: 8px;
            --transition: all 0.3s ease;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
        }
        
        html {
            scroll-behavior: smooth;
        }
        
        body {
            background-color: var(--light);
            color: var(--dark);
            line-height: 1.5;
            font-size: 16px;
        }
        
        a {
            text-decoration: none;
            color: inherit;
        }
        
        .container {
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar Styles */
        .sidebar {
            width: 250px;
            background: linear-gradient(to bottom, var(--primary-dark), #004b8f);
            color: var(--white);
            padding: 20px 0;
            position: fixed;
            height: 100%;
            overflow-y: auto;
            z-index: 1000;
            transition: var(--transition);
            -webkit-overflow-scrolling: touch;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.05);
        }
        
        .sidebar::-webkit-scrollbar {
            width: 4px;
        }
        
        .sidebar::-webkit-scrollbar-thumb {
            background-color: rgba(255, 255, 255, 0.2);
            border-radius: 4px;
        }
        
        .sidebar-header {
            padding: 0 20px 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
        }
        
        .logo {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-bottom: 10px;
        }
        
        .logo img {
            max-width: 120px;
            height: auto;
            margin-bottom: 10px;
            filter: drop-shadow(0 0 3px rgba(255, 255, 255, 0.7));
            transition: transform 0.3s ease;
            -webkit-backface-visibility: hidden;
            backface-visibility: hidden;
        }
        
        .logo img:hover {
            transform: scale(1.05);
        }
        
        .logo-text {
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 0.5px;
            color: var(--white);
        }
        
        .menu {
            margin-top: 25px;
        }
        
        .menu-category {
            margin: 10px 0;
            padding: 0 20px;
            font-size: 12px;
            text-transform: uppercase;
            color: rgba(255, 255, 255, 0.5);
            letter-spacing: 1px;
        }
        
        .menu-item {
            padding: 12px 20px;
            display: flex;
            align-items: center;
            transition: var(--transition);
            cursor: pointer;
            color: var(--white);
            position: relative;
            overflow: hidden;
        }
        
        .menu-item::after {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            height: 2px;
            width: 0;
            background-color: var(--white);
            transition: width 0.3s ease;
        }
        
        .menu-item:hover::after, .menu-item.active::after {
            width: 100%;
        }
        
        .menu-item:hover, .menu-item.active {
            background-color: rgba(255, 255, 255, 0.1);
            transform: translateX(5px);
        }
        
        .menu-icon {
            margin-right: 10px;
            font-size: 18px;
            transition: transform 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .menu-item:hover .menu-icon {
            transform: rotate(5deg);
        }
        
        /* Content Styles */
        .content {
            flex: 1;
            margin-left: 250px;
            padding: 20px;
            transition: var(--transition);
            max-width: 100%;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            flex-wrap: wrap;
            gap: 15px;
        }
        
        .page-title {
            font-size: 26px;
            font-weight: 600;
            color: var(--dark);
        }
        
        /* User Profile Dropdown */
        .user-profile {
            display: flex;
            align-items: center;
            position: relative;
            cursor: pointer;
            padding: 5px;
            border-radius: var(--border-radius);
            transition: background-color 0.3s ease;
        }
        
        .user-profile:hover {
            background-color: rgba(0, 0, 0, 0.05);
        }
        
        .avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: var(--primary);
            color: var(--white);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 10px;
            font-weight: 600;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
            transition: transform 0.3s ease;
        }
        
        .user-profile:hover .avatar {
            transform: scale(1.1);
        }
        
        .user-info {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
        }
        
        .user-name {
            font-weight: 500;
        }
        
        .user-role {
            font-size: 12px;
            color: var(--gray);
        }
        
        .dropdown {
            position: relative;
            display: inline-block;
        }
        
        .dropdown-content {
            display: none;
            position: absolute;
            right: 0;
            background-color: var(--white);
            min-width: 180px;
            box-shadow: var(--shadow);
            z-index: 1;
            border-radius: var(--border-radius);
            overflow: hidden;
            animation: fadeIn 0.3s ease;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .dropdown-content a {
            color: var(--dark);
            padding: 12px 16px;
            text-decoration: none;
            display: block;
            font-size: 14px;
            transition: var(--transition);
        }
        
        .dropdown-content a:hover {
            background-color: var(--light);
            padding-left: 20px;
        }
        
        .dropdown:hover .dropdown-content {
            display: block;
        }
        
        /* Alert Messages */
        .alert {
            padding: 12px 15px;
            border-radius: var(--border-radius);
            margin-bottom: 20px;
            font-size: 14px;
            animation: fadeIn 0.5s;
            position: relative;
            padding-right: 35px;
        }
        
        .alert-success {
            background-color: rgba(102, 187, 106, 0.2);
            color: var(--success);
            border: 1px solid rgba(102, 187, 106, 0.3);
        }
        
        .alert-danger {
            background-color: rgba(239, 83, 80, 0.2);
            color: var(--danger);
            border: 1px solid rgba(239, 83, 80, 0.3);
        }
        
        .alert-warning {
            background-color: rgba(255, 167, 38, 0.2);
            color: var(--warning);
            border: 1px solid rgba(255, 167, 38, 0.3);
        }
        
        .alert-info {
            background-color: rgba(30, 136, 229, 0.2);
            color: var(--primary);
            border: 1px solid rgba(30, 136, 229, 0.3);
        }
        
        /* Toggle Sidebar Button (Mobile) */
        .toggle-sidebar {
            background: none;
            border: none;
            color: var(--white);
            cursor: pointer;
            font-size: 24px;
            display: none;
            width: 40px;
            height: 40px;
            align-items: center;
            justify-content: center;
            position: fixed;
            top: 10px;
            left: 10px;
            z-index: 1001;
            border-radius: 50%;
            box-shadow: var(--shadow);
        }
        
        /* Responsive Adjustments */
        @media (max-width: 992px) {
            .content {
                padding: 15px;
            }
            
            .header {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .header > div {
                width: 100%;
            }
        }
        
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                box-shadow: none;
            }
            
            .sidebar.active {
                transform: translateX(0);
                box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
            }
            
            .content {
                margin-left: 0;
            }
            
            .toggle-sidebar {
                display: flex;
                background-color: var(--primary);
            }
            
            .header {
                margin-top: 30px;
            }
            
            .user-profile {
                width: auto;
            }
        }
        
        /* Common UI Components */
        .card {
            background-color: var(--white);
            border-radius: var(--border-radius);
            padding: 20px;
            box-shadow: var(--shadow);
            margin-bottom: 20px;
            transition: var(--transition);
        }
        
        .card:hover {
            box-shadow: var(--shadow-hover);
        }
        
        .panel-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            flex-wrap: wrap;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
            gap: 10px;
        }
        
        .panel-title {
            font-size: 20px;
            font-weight: 600;
            margin: 0;
            color: var(--dark);
        }
        
        /* Buttons */
        .btn {
            padding: 8px 16px;
            border-radius: var(--border-radius);
            border: none;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            line-height: 1.5;
        }
        
        .btn:focus {
            outline: none;
            box-shadow: 0 0 0 3px rgba(30, 136, 229, 0.25);
        }
        
        .btn-primary {
            background-color: var(--primary);
            color: var(--white);
        }
        
        .btn-primary:hover {
            background-color: var(--primary-dark);
        }
        
        .btn-success {
            background-color: var(--success);
            color: var(--white);
        }
        
        .btn-success:hover {
            background-color: #4caf50;
        }
        
        .btn-danger {
            background-color: var(--danger);
            color: var(--white);
        }
        
        .btn-danger:hover {
            background-color: #e53935;
        }
        
        .btn-warning {
            background-color: var(--warning);
            color: var(--white);
        }
        
        .btn-warning:hover {
            background-color: #fb8c00;
        }
        
        .btn-secondary {
            background-color: var(--secondary);
            color: var(--white);
        }
        
        .btn-secondary:hover {
            background-color: #00897b;
        }
        
        .btn-sm {
            padding: 5px 10px;
            font-size: 12px;
        }
        
        .btn i {
            margin-right: 5px;
        }
        
        /* Tables */
        .table-responsive {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            border-spacing: 0;
        }
        
        thead th {
            text-align: left;
            padding: 12px 15px;
            border-bottom: 1px solid #ddd;
            font-weight: 600;
            color: var(--dark);
            white-space: nowrap;
        }
        
        tbody td {
            padding: 12px 15px;
            border-bottom: 1px solid #eee;
            vertical-align: middle;
        }
        
        tbody tr:hover {
            background-color: rgba(0, 0, 0, 0.02);
        }
        
        /* Forms */
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--dark);
        }
        
        .form-control {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 14px;
            transition: var(--transition);
        }
        
        .form-control:focus {
            border-color: var(--primary);
            outline: none;
            box-shadow: 0 0 0 2px rgba(30, 136, 229, 0.25);
        }
        
        /* Status Badges */
        .status-badge {
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
            display: inline-block;
            text-align: center;
        }
        
        .badge-estado-1 {
            background-color: rgba(255, 167, 38, 0.2);
            color: var(--warning);
        }
        
        .badge-estado-2 {
            background-color: rgba(30, 136, 229, 0.2);
            color: var(--primary);
        }
        
        .badge-estado-3 {
            background-color: rgba(102, 187, 106, 0.2);
            color: var(--success);
        }
        
        .badge-estado-4 {
            background-color: rgba(239, 83, 80, 0.2);
            color: var(--danger);
        }
        
        .badge-estado-5 {
            background-color: rgba(96, 125, 139, 0.2);
            color: var(--gray);
        }
        
        /* Dashboard UI Components */
        /* Dashboard Cards */
        .dashboard-stats {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            transition: all 0.3s;
            border: 1px solid rgba(0,0,0,0.05);
            height: 100%;
        }
        
        .stat-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }
        
        .stat-card-header {
            padding: 15px;
            color: white;
            display: flex;
            align-items: center;
        }
        
        .stat-card-header i {
            font-size: 24px;
            margin-right: 10px;
        }
        
        .stat-card-header h3 {
            margin: 0;
            font-size: 16px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .stat-card-body {
            padding: 20px;
            text-align: center;
        }
        
        .stat-value {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 5px;
            color: #333;
        }
        
        .stat-amount {
            font-size: 18px;
            font-weight: 600;
            color: #546e7a;
            margin-bottom: 8px;
        }
        
        .stat-label {
            font-size: 14px;
            color: #6c757d;
        }
        
        /* Quick Actions */
        .quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .action-card {
            background-color: white;
            border-radius: 8px;
            padding: 25px 20px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
            border: 1px solid rgba(0,0,0,0.05);
            height: 100%;
        }
        
        .action-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.1);
        }
        
        .action-icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 15px;
            color: white;
        }
        
        .action-icon i {
            font-size: 24px;
        }
        
        .action-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 8px;
            color: #333;
        }
        
        .action-description {
            color: #607d8b;
            font-size: 14px;
        }
        
        /* Chart container */
        .chart-container {
            position: relative;
            margin-bottom: 20px;
            height: 300px;
        }
        
        /* Background colors */
        .primary-bg { background-color: var(--primary); }
        .success-bg { background-color: var(--success); }
        .warning-bg { background-color: var(--warning); }
        .danger-bg { background-color: var(--danger); }
        .secondary-bg { background-color: var(--secondary); }
        
        /* Helper classes */
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .text-left { text-align: left; }
        .mb-0 { margin-bottom: 0; }
        .mt-0 { margin-top: 0; }
        .ml-auto { margin-left: auto; }
        .mr-auto { margin-right: auto; }
        .d-flex { display: flex; }
        .align-items-center { align-items: center; }
        .justify-content-between { justify-content: space-between; }
        .w-100 { width: 100%; }
        .h-100 { height: 100%; }
    </style>
</head>
<body>
    <div class="container">
        <!-- Botón para mostrar/ocultar sidebar en móviles -->
        <button class="toggle-sidebar" aria-label="Toggle sidebar menu">
            <i class="material-icons">menu</i>
        </button>
        
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <div class="logo">
                    <img src="assets/img/logo.png" alt="Gestión Doc. Logo">
                    <span class="logo-text">Gestión de Doc.</span>
                </div>
            </div>
            <nav class="menu">
                <div class="menu-category">Principal</div>
                <a href="dashboard.php" class="menu-item <?php echo $current_page === 'dashboard.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'dashboard.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">dashboard</i>
                    Dashboard
                </a>
                
                <div class="menu-category">Documentos</div>
                
                <?php if (tienePermiso('ver_rendiciones') || tienePermiso('crear_rendicion') || $is_admin): ?>
                <a href="rendiciones.php" class="menu-item <?php echo $current_page === 'rendiciones.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'rendiciones.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">receipt</i>
                    Rendiciones
                </a>
                <?php endif; ?>
                
                <?php if (tienePermiso('ver_devoluciones') || tienePermiso('crear_devolucion') || $is_admin): ?>
                <a href="devoluciones.php" class="menu-item <?php echo $current_page === 'devoluciones.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'devoluciones.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">money_off</i>
                    Devoluciones
                </a>
                <?php endif; ?>
                
                <?php if (tienePermiso('ver_ordenes_compra') || tienePermiso('crear_orden_compra') || $is_admin): ?>
                <a href="ordenes_compra.php" class="menu-item <?php echo $current_page === 'ordenes_compra.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'ordenes_compra.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">shopping_cart</i>
                    Órdenes de Compra
                </a>
                <?php endif; ?>
                
                <!-- Sección "Inventario y Equipos" -->
                
                <div class="menu-category">Inventario y Equipos</div>
                                
                <?php if (tienePermiso('ver_maquinas') || tienePermiso('crear_maquina') || $is_admin): ?>
                <a href="maquinas.php" class="menu-item <?php echo $current_page === 'maquinas.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'maquinas.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">precision_manufacturing</i>
                    Creación de Máquinas
                </a>
                <?php endif; ?>
                                
                <?php if (tienePermiso('ver_repuestos') || tienePermiso('crear_repuesto') || $is_admin): ?>
                <a href="repuestos.php" class="menu-item <?php echo $current_page === 'repuestos.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'repuestos.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">build</i>
                    Creación de Repuestos
                </a>
                <?php endif; ?>
                                
                <?php if (tienePermiso('ver_solicitudes_repuesto') || tienePermiso('ver_solicitudes_repuesto') || $is_admin): ?>
                <a href="solicitud_repuestos.php" class="menu-item <?php echo $current_page === 'solicitud_repuestos.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'solicitud_repuestos.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">assignment</i>
                    Solicitud de Repuestos
                </a>
                <?php endif; ?>
                
                <div class="menu-category">Reportes</div>
                
                <a href="historial.php" class="menu-item <?php echo $current_page === 'historial.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'historial.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">history</i>
                    Historial
                </a>
                
                <?php if (tienePermiso('ver_reportes') || $is_admin): ?>
                <a href="reportes.php" class="menu-item <?php echo $current_page === 'reportes.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'reportes.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">analytics</i>
                    Reportes
                </a>
                <?php endif; ?>
                
                <?php if ($is_admin): ?>
                <div class="menu-category">Administración</div>
                
                <a href="usuarios.php" class="menu-item <?php echo $current_page === 'usuarios.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'usuarios.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">people</i>
                    Usuarios
                </a>
                
                <?php if ($is_super_admin && tienePermiso('acceso_admin_sistema')): ?>
                <a href="admin_sistema.php" class="menu-item <?php echo $current_page === 'admin_sistema.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'admin_sistema.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">admin_panel_settings</i>
                    Administración del Sistema
                </a>
                <?php endif; ?>
                
                <a href="proveedores.php" class="menu-item <?php echo $current_page === 'proveedores.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'proveedores.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">business</i>
                    Proveedores y Clientes
                </a>
                
                <a href="importacion_exportacion.php" class="menu-item <?php echo $current_page === 'importacion_exportacion.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'importacion_exportacion.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">cloud_upload</i>
                    Importar y Exportar
                </a>
                <?php endif; ?>
                
                <div class="menu-category">Usuario</div>
                
                <a href="perfil.php" class="menu-item <?php echo $current_page === 'perfil.php' ? 'active' : ''; ?>" aria-current="<?php echo $current_page === 'perfil.php' ? 'page' : 'false'; ?>">
                    <i class="material-icons menu-icon">person</i>
                    Mi Perfil
                </a>
                
                <a href="logout.php" class="menu-item">
                    <i class="material-icons menu-icon">logout</i>
                    Cerrar Sesión
                </a>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="content">
            <div class="header">
                <h1 class="page-title"><?php echo htmlspecialchars($page_title ?? 'Dashboard'); ?></h1>
                <div class="user-profile dropdown">
                    <div class="avatar" aria-label="Imagen de perfil"><?php echo htmlspecialchars($user_iniciales); ?></div>
                    <div class="user-info">
                        <div class="user-name"><?php echo htmlspecialchars($user_nombre . ' ' . $user_apellido); ?></div>
                        <div class="user-role">
                            <?php 
                                switch($user_rol) {
                                    case 'super_admin':
                                        echo 'Super Administrador';
                                        break;
                                    case 'admin':
                                        echo 'Administrador';
                                        break;
                                    default:
                                        echo 'Usuario';
                                }
                            ?>
                        </div>
                    </div>
                    <div class="dropdown-content">
                        <a href="perfil.php">
                            <i class="material-icons" style="font-size: 16px; vertical-align: middle; margin-right: 5px;">person</i>
                            Mi Perfil
                        </a>
                        <a href="logout.php">
                            <i class="material-icons" style="font-size: 16px; vertical-align: middle; margin-right: 5px;">logout</i>
                            Cerrar Sesión
                        </a>
                    </div>
                </div>
            </div>
            
            <?php 
            // Mostrar mensaje flash si existe
            echo mostrarMensajeFlash(); 
            ?>