<?php
/**
 * Archivo de configuración del sistema
 * Contiene variables globales y configuración de la base de datos
 */

// Configuración de codificación UTF-8
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');
mb_http_output('UTF-8');
mb_regex_encoding('UTF-8');
ini_set('default_charset', 'utf-8');

// Modo de depuración (cambiar a false en producción)
define('DEBUG_MODE', false); // Cambia a true para depuración

// Configuración de base de datos
$db_host = 'localhost'; // Host de la base de datos
$db_name = 'santavictoria_t0l1g3'; // Nombre de la base de datos
$db_user = 'santavictoria_s3rv1c10'; // Usuario de la base de datos (cambiar en producción)
$db_pass = 'd.=[YeZkc}]h'; // Contraseña de la base de datos (cambiar en producción)
$db_charset = 'utf8mb4'; // Charset para soporte completo de Unicode

// Configuración de PDO para UTF-8 garantizada
$db_options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci",
    PDO::MYSQL_ATTR_FOUND_ROWS => true
];

// Función para crear la conexión PDO con manejo de codificación
function getDatabaseConnection() {
    global $db_host, $db_name, $db_user, $db_pass, $db_options;
    
    try {
        $conn = new PDO(
            "mysql:host=$db_host;dbname=$db_name;charset=utf8mb4",
            $db_user,
            $db_pass,
            $db_options
        );
        
        // Configuración adicional después de la conexión
        $conn->exec("SET CHARACTER SET utf8mb4");
        $conn->exec("SET NAMES utf8mb4");
        
        // Verificación de codificación (para depuración)
        if (defined('DEBUG_MODE') && DEBUG_MODE) {
            $charset = $conn->query("SELECT @@character_set_client")->fetchColumn();
            error_log("Charset de conexión: $charset");
        }
        
        return $conn;
    } catch (PDOException $e) {
        // Manejo de errores
        if (defined('DEBUG_MODE') && DEBUG_MODE) {
            error_log('Error de conexión a la base de datos: ' . $e->getMessage());
            die('Error de conexión: ' . $e->getMessage());
        } else {
            header('Location: ' . BASE_URL . 'error.php');
            exit;
        }
    }
}

// Crear la conexión global
$conn = getDatabaseConnection();

// Configuración de la aplicación
define('APP_NAME', 'Sistema de Rendiciones Figaro');
define('APP_VERSION', '1.8.0');
define('COMPANY_NAME', 'COMERCIAL FIGARO LIMITADA');

// URL base de la aplicación (ajustar según entorno)
$base_url = 'http' . (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 's' : '') . '://' . $_SERVER['HTTP_HOST'] . '/sisrendiciones/';
define('BASE_URL', $base_url);

// Directorio de carga de archivos
define('UPLOAD_DIR', 'uploads/');
define('COMPROBANTES_DIR', UPLOAD_DIR . 'uploads/comprobantes/');

// Crear directorios si no existen
if (!file_exists(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}
if (!file_exists(COMPROBANTES_DIR)) {
    mkdir(COMPROBANTES_DIR, 0755, true);
}

// Tamaño máximo de archivo (en bytes) - 5MB
define('MAX_FILE_SIZE', 5 * 1024 * 1024);

// Tipos MIME permitidos para cargas
$allowed_mimetypes = [
    'image/jpeg',
    'image/png',
    'image/gif',
    'application/pdf',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', // xlsx
    'application/vnd.ms-excel', // xls
    'text/csv'
];

// Configuración de correo electrónico
define('MAIL_HOST', 'smtp.tuempresa.cl');
define('MAIL_PORT', 587);
define('MAIL_USERNAME', 'notificaciones@tuempresa.cl');
define('MAIL_PASSWORD', 'mail_password'); // Cambiar en producción
define('MAIL_FROM_NAME', APP_NAME);

// Configuración de sesión
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 1 : 0);
session_name('SISRENDICIONES_SESSION');

// Manejo de errores según el modo de depuración
if (DEBUG_MODE) {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT);
}

// Función para manejar errores fatales
function shutdownHandler() {
    $error = error_get_last();
    if ($error !== null && in_array($error['type'], [E_ERROR, E_CORE_ERROR, E_COMPILE_ERROR, E_PARSE])) {
        if (DEBUG_MODE) {
            echo '<h1>Error Fatal</h1>';
            echo '<p><strong>Mensaje:</strong> ' . $error['message'] . '</p>';
            echo '<p><strong>Archivo:</strong> ' . $error['file'] . '</p>';
            echo '<p><strong>Línea:</strong> ' . $error['line'] . '</p>';
        } else {
            // Redireccionar a una página de error o mostrar un mensaje amigable
            header('Location: ' . BASE_URL . 'error.php');
            exit;
        }
    }
}

register_shutdown_function('shutdownHandler');