-- Respaldo de base de datos
-- Fecha: 2025-03-17 01:53:50
-- Base de datos: santavictoria_t0l1g3

SET FOREIGN_KEY_CHECKS=0;



CREATE TABLE `archivos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rendicion_id` int(11) DEFAULT NULL,
  `orden_compra_id` int(11) DEFAULT NULL,
  `nombre_original` varchar(255) NOT NULL,
  `nombre_archivo` varchar(255) NOT NULL,
  `tipo` varchar(100) NOT NULL,
  `ruta` varchar(255) NOT NULL,
  `tamano` int(11) NOT NULL,
  `fecha_subida` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `rendicion_id` (`rendicion_id`),
  KEY `guia_entrada_id` (`orden_compra_id`),
  CONSTRAINT `archivos_ibfk_1` FOREIGN KEY (`rendicion_id`) REFERENCES `rendiciones` (`id`) ON DELETE CASCADE,
  CONSTRAINT `archivos_ibfk_2` FOREIGN KEY (`orden_compra_id`) REFERENCES `ordenes_compra` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



CREATE TABLE `categorias_gastos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `descripcion` mediumtext DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `categorias_gastos` VALUES ("1","Transporte","Gastos relacionados con transporte y movilización","1");
INSERT INTO `categorias_gastos` VALUES ("2","Alimentación","Gastos de alimentación y viáticos","1");
INSERT INTO `categorias_gastos` VALUES ("3","Hospedaje","Gastos de alojamiento","1");
INSERT INTO `categorias_gastos` VALUES ("4","Material de oficina","Suministros y materiales de oficina","1");
INSERT INTO `categorias_gastos` VALUES ("5","Representación","Gastos de representación y atención a clientes","1");
INSERT INTO `categorias_gastos` VALUES ("6","Comunicaciones","Teléfono, internet y comunicaciones","1");
INSERT INTO `categorias_gastos` VALUES ("7","Otros","Gastos varios no categorizados","1");


CREATE TABLE `categorias_repuestos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `descripcion` mediumtext DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



CREATE TABLE `detalle_orden_compra` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guia_entrada_id` int(11) DEFAULT NULL,
  `producto` varchar(255) NOT NULL,
  `codigo_producto` varchar(50) DEFAULT NULL,
  `cantidad` int(11) NOT NULL,
  `precio_unitario` decimal(15,2) NOT NULL,
  `descuento` decimal(5,2) DEFAULT 0.00,
  `precio_final` decimal(15,2) DEFAULT NULL,
  `subtotal` decimal(15,2) NOT NULL,
  `codigo_proveedor` varchar(50) DEFAULT NULL,
  `orden_compra_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `guia_entrada_id` (`guia_entrada_id`),
  CONSTRAINT `detalle_orden_compra_ibfk_1` FOREIGN KEY (`guia_entrada_id`) REFERENCES `ordenes_compra` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `detalle_orden_compra` VALUES ("1","5","Redencion",NULL,"1","25000.00","0.00","25000.00","25000.00",NULL,"5");
INSERT INTO `detalle_orden_compra` VALUES ("2","6","PRUEBA",NULL,"1","20000.00","0.00","20000.00","20000.00",NULL,"6");
INSERT INTO `detalle_orden_compra` VALUES ("4",NULL,"PRUEBA 1",NULL,"1","4000.00","0.00","4000.00","4000.00",NULL,"9");
INSERT INTO `detalle_orden_compra` VALUES ("5",NULL,"Pruena 2",NULL,"30","2000.00","0.00","2000.00","60000.00",NULL,"9");
INSERT INTO `detalle_orden_compra` VALUES ("6",NULL,"MERCADOLIBRE APP",NULL,"50","12990.00","0.00","12990.00","649500.00",NULL,"10");
INSERT INTO `detalle_orden_compra` VALUES ("16",NULL,"Producto de Prueba ","040101125","1","20000.00","10.00","18000.00","18000.00",NULL,"11");
INSERT INTO `detalle_orden_compra` VALUES ("17",NULL,"Producto de Prueba 2","040101126","1","15000.00","0.00","15000.00","15000.00",NULL,"11");
INSERT INTO `detalle_orden_compra` VALUES ("18",NULL,"Producto de Prueba 3","040101127","2","40000.00","6.00","37600.00","75200.00",NULL,"11");


CREATE TABLE `devolucion_soportes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `devolucion_id` int(11) NOT NULL,
  `nombre_archivo` varchar(255) NOT NULL,
  `ruta_archivo` varchar(255) NOT NULL,
  `fecha_subida` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_devolucion_soportes_devolucion` (`devolucion_id`),
  CONSTRAINT `fk_devolucion_soportes_devolucion` FOREIGN KEY (`devolucion_id`) REFERENCES `devoluciones` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



CREATE TABLE `devoluciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `descripcion` mediumtext NOT NULL,
  `origen_id` int(11) NOT NULL,
  `motivo_id` int(11) NOT NULL,
  `otro_motivo` mediumtext DEFAULT NULL,
  `fecha` date NOT NULL,
  `monto_total` decimal(15,2) NOT NULL DEFAULT 0.00,
  `estado_id` int(11) NOT NULL,
  `revisor_id` int(11) DEFAULT NULL,
  `comentario_revision` mediumtext DEFAULT NULL,
  `fecha_revision` datetime DEFAULT NULL,
  `fecha_creacion` datetime NOT NULL,
  `ultima_modificacion` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_devoluciones_user` (`user_id`),
  KEY `fk_devoluciones_origen` (`origen_id`),
  KEY `fk_devoluciones_motivo` (`motivo_id`),
  KEY `fk_devoluciones_estado` (`estado_id`),
  KEY `fk_devoluciones_revisor` (`revisor_id`),
  CONSTRAINT `fk_devoluciones_estado` FOREIGN KEY (`estado_id`) REFERENCES `estados` (`id`),
  CONSTRAINT `fk_devoluciones_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



CREATE TABLE `estados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `descripcion` mediumtext DEFAULT NULL,
  `color` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `estados` VALUES ("1","Enviada","Documento enviado, pendiente de revisión","#FFC107");
INSERT INTO `estados` VALUES ("2","En revisión","Documento en proceso de revisión","#3498DB");
INSERT INTO `estados` VALUES ("3","Aprobada","Documento aprobado","#28A745");
INSERT INTO `estados` VALUES ("4","Rechazada","Documento rechazado","#DC3545");
INSERT INTO `estados` VALUES ("5","Pagada","Documento pagado","#6C757D");


CREATE TABLE `estados_maquina` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_nombre` (`nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `estados_maquina` VALUES ("1","nueva","Máquina nueva sin usar","1");
INSERT INTO `estados_maquina` VALUES ("2","usada","Máquina en uso normal","1");
INSERT INTO `estados_maquina` VALUES ("3","servicio_tecnico","En servicio técnico o reparación","1");
INSERT INTO `estados_maquina` VALUES ("4","comodato","En comodato con cliente","1");
INSERT INTO `estados_maquina` VALUES ("5","devuelta","Devuelta por el cliente","1");
INSERT INTO `estados_maquina` VALUES ("6","irreparable","No puede ser reparada","1");


CREATE TABLE `historial_cambios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `tipo` varchar(50) NOT NULL,
  `descripcion` mediumtext NOT NULL,
  `documento_id` int(11) DEFAULT NULL,
  `documento_tipo` varchar(50) DEFAULT NULL,
  `fecha_hora` datetime NOT NULL,
  `ip_address` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `historial_cambios_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=518 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `historial_cambios` VALUES ("1","1","crear","Creación de usuario","2","usuario","2025-03-06 07:18:04","127.0.0.1");
INSERT INTO `historial_cambios` VALUES ("2","2","crear","Creación de rendición de gastos","1","rendicion","2024-02-16 10:30:00","127.0.0.1");
INSERT INTO `historial_cambios` VALUES ("3","2","crear","Creación de rendición de gastos","2","rendicion","2024-01-26 14:45:00","127.0.0.1");
INSERT INTO `historial_cambios` VALUES ("4","1","aprobar","Aprobación de rendición","2","rendicion","2024-01-28 09:20:00","127.0.0.1");
INSERT INTO `historial_cambios` VALUES ("5","2","crear","Creación de nota de venta","1","nota_venta","2024-03-01 11:20:00","127.0.0.1");
INSERT INTO `historial_cambios` VALUES ("6","2","crear","Creación de nota de venta","2","nota_venta","2024-02-20 16:10:00","127.0.0.1");
INSERT INTO `historial_cambios` VALUES ("7","1","rechazar","Rechazo de nota de venta","2","nota_venta","2024-02-21 10:15:00","127.0.0.1");
INSERT INTO `historial_cambios` VALUES ("8","1","login","Inicio de sesiÃ³n exitoso",NULL,NULL,"2025-03-06 07:18:52","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("9","1","login","Inicio de sesiÃ³n exitoso",NULL,NULL,"2025-03-06 09:27:11","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("10","1","editar","ActualizaciÃ³n de perfil personal","1","usuario","2025-03-06 10:32:10","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("11","1","editar","ActualizaciÃ³n de perfil personal","1","usuario","2025-03-06 11:21:54","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("12","1","crear","CreaciÃ³n de rendiciÃ³n","3","rendicion","2025-03-06 12:31:20","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("13","1","crear","Creación de usuario: Jimmy Jimenez","3","usuario","2025-03-06 12:49:30","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("14","1","aprobar","AprobaciÃ³n de rendiciÃ³n","1","rendicion","2025-03-06 13:17:20","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("15","1","aprobar","AprobaciÃ³n de rendiciÃ³n","3","rendicion","2025-03-06 13:17:26","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("16","3","login","Inicio de sesiÃ³n exitoso",NULL,NULL,"2025-03-06 13:43:18","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("17","3","login","Inicio de sesiÃ³n exitoso",NULL,NULL,"2025-03-07 09:41:33","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("18","3","descargar","Descarga de PDF: REN-2025-003","3","rendicion","2025-03-07 09:42:48","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("19","1","descargar","Descarga de PDF: REN-2025-003","3","rendicion","2025-03-07 09:59:28","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("20","1","descargar","Descarga de PDF: REN-2025-003","3","rendicion","2025-03-07 09:59:28","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("21","3","login","Inicio de sesiÃ³n exitoso",NULL,NULL,"2025-03-07 10:29:44","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("22","1","crear","CreaciÃ³n de rendiciÃ³n (inserciÃ³n directa)","7","rendicion","2025-03-07 11:43:37","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("23","1","crear","Creación de rendición","8","rendicion","2025-03-07 12:42:12","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("24","1","editar","Edición de rendición","8","rendicion","2025-03-07 12:42:44","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("25","1","aprobar","Aprobación de rendición","8","rendicion","2025-03-07 12:43:03","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("26","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-07 12:43:08","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("27","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-07 12:43:08","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("28","1","editar","Edición de rendición","7","rendicion","2025-03-07 12:49:21","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("29","1","editar","Edición de rendición","7","rendicion","2025-03-07 12:49:24","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("30","1","crear","Creación de orden de compra","5","orden_compra","2025-03-07 12:58:27","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("31","1","crear","Creación de permisos para órdenes de compra",NULL,"sistema","2025-03-07 13:07:09","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("32","1","editar","Actualización de perfil personal","1","usuario","2025-03-07 13:43:42","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("33","1","editar","Actualización de perfil personal","1","usuario","2025-03-07 13:43:56","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("34","1","editar","Actualización de perfil personal","1","usuario","2025-03-07 13:46:31","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("35","3","login","Inicio de sesiÃ³n exitoso",NULL,NULL,"2025-03-07 14:25:22","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("36","1","aprobar","Aprobación de orden de compra","5","orden_compra","2025-03-07 14:30:37","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("37","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 14:32:57","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("38","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 14:32:58","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("39","3","login","Inicio de sesiÃ³n exitoso",NULL,NULL,"2025-03-07 14:36:42","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("40","1","editar","Actualización de perfil personal","1","usuario","2025-03-07 15:09:33","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("41","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-07 15:15:24","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("42","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-07 15:15:24","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("43","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 15:25:27","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("44","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 15:25:27","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("45","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 15:28:06","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("46","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 15:28:06","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("47","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-07 15:38:58","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("48","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-07 15:38:58","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("49","1","eliminar","Eliminación de rendición","7","rendicion","2025-03-07 15:54:56","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("50","1","eliminar","Eliminación de rendición","6","rendicion","2025-03-07 15:54:58","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("51","1","eliminar","Eliminación de rendición","5","rendicion","2025-03-07 15:55:00","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("52","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 15:55:19","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("53","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 15:55:19","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("54","1","descargar","Descarga de PDF: REN-2025-003","3","rendicion","2025-03-07 15:56:52","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("55","1","descargar","Descarga de PDF: REN-2025-003","3","rendicion","2025-03-07 15:56:53","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("56","1","descargar","Descarga de PDF: REN-2025-003","3","rendicion","2025-03-07 16:03:54","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("57","1","descargar","Descarga de PDF: REN-2025-003","3","rendicion","2025-03-07 16:03:55","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("58","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:11:51","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("59","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:17:01","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("60","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:18:14","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("61","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:20:39","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("62","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:20:40","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("63","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:20:41","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("64","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:20:42","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("65","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:20:42","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("66","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:20:43","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("67","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:20:43","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("68","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:20:43","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("69","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-07 16:20:52","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("70","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-07 16:20:53","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("71","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-07 16:28:09","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("72","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-07 16:28:10","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("73","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:28:46","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("74","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:28:46","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("75","3","login","Inicio de sesiÃ³n exitoso",NULL,NULL,"2025-03-07 16:35:05","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("76","1","crear","Creación de rendición","9","rendicion","2025-03-07 16:40:58","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("77","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:41:30","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("78","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 16:41:30","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("79","1","login","Inicio de sesiÃ³n exitoso",NULL,NULL,"2025-03-07 19:38:09","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("80","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-07 20:10:06","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("81","1","crear","Creación de proveedor: COMEMOS SPA","1","proveedor","2025-03-07 20:41:06","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("82","1","logout","Salir de la cuenta",NULL,NULL,"2025-03-07 21:12:28","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("83","1","login","Inicio de sesiÃ³n exitoso",NULL,NULL,"2025-03-07 21:14:54","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("84","1","editar","Edición de usuario: Jonathan López","1","usuario","2025-03-07 21:15:15","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("85","1","editar","Edición de usuario: Jonathan López","1","usuario","2025-03-07 21:15:28","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("86","1","logout","Salir de la cuenta",NULL,NULL,"2025-03-07 21:16:30","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("87","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-07 21:16:57","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("88","1","crear","Creación de usuario: Alejandro Delgado","4","usuario","2025-03-07 21:20:16","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("89","4","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-07 21:20:37","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("90","1","editar","Edición de usuario: Alejandro Delgado","4","usuario","2025-03-07 21:21:30","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("91","4","crear","Creación de rendición","10","rendicion","2025-03-07 21:51:02","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("92","4","editar","Actualización de perfil personal","4","usuario","2025-03-07 21:53:25","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("93","1","crear","Creación de orden de compra","6","orden_compra","2025-03-07 22:09:16","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("96","1","crear","Creación de orden de compra","9","orden_compra","2025-03-07 22:21:51","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("97","1","editar","Edición de orden de compra","9","orden_compra","2025-03-07 22:22:14","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("98","4","editar","Edición de rendición","10","rendicion","2025-03-07 22:22:52","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("99","4","crear","Creación de orden de compra","10","orden_compra","2025-03-07 22:23:32","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("100","3","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-08 00:19:18","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("101","3","editar","Edición de usuario: Jonathan López","1","usuario","2025-03-08 00:19:40","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("102","3","logout","Salir de la cuenta",NULL,NULL,"2025-03-08 00:22:25","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("103","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-08 00:23:07","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("104","1","editar","Edición de usuario: Jonathan López","1","usuario","2025-03-08 00:23:37","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("105","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 00:25:07","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("106","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 00:26:56","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("107","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 00:30:36","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("108","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 00:32:59","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("109","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 00:33:00","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("110","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 00:33:52","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("111","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-08 00:40:06","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("112","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-08 00:40:28","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("113","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-08 00:43:32","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("114","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-08 00:44:42","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("115","1","aprobar","Aprobación de orden de compra","10","orden_compra","2025-03-08 00:45:05","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("116","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 00:45:07","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("117","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-08 00:49:55","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("118","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-08 00:50:08","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("119","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 00:50:40","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("120","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 00:50:52","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("121","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 00:53:35","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("122","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 00:53:35","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("123","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 00:53:36","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("124","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 00:55:16","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("125","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 00:55:17","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("126","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 00:55:21","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("127","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 00:55:23","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("128","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 00:57:45","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("129","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 00:57:46","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("130","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 00:58:10","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("131","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 00:58:22","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("132","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-08 01:18:18","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("133","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:27:27","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("134","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:37:23","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("135","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:37:55","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("136","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:38:05","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("137","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 01:38:32","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("138","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 01:38:40","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("139","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 01:42:50","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("140","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 01:42:51","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("141","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:44:44","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("142","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:44:44","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("143","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 01:45:05","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("144","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:49:44","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("145","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:49:45","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("146","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:49:46","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("147","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:49:48","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("148","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 01:49:51","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("149","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 01:49:52","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("150","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 01:49:52","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("151","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:49:58","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("152","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:49:59","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("153","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:50:00","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("154","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:50:00","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("155","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:50:01","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("156","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:50:02","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("157","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:50:03","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("158","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:50:04","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("159","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:50:04","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("160","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:50:05","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("161","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:50:06","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("162","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:50:06","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("163","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:50:06","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("164","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 01:52:16","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("165","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:52:18","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("166","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:52:18","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("167","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:52:19","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("168","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:53:14","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("169","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:53:14","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("170","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:53:15","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("171","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:53:40","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("172","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:53:41","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("173","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 01:56:06","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("174","1","descargar","Descarga de PDF: REN-2025-001","1","rendicion","2025-03-08 01:59:01","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("175","1","descargar","Descarga de PDF: REN-2025-001","1","rendicion","2025-03-08 02:01:24","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("176","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:16:41","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("177","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-08 02:17:08","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("178","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 02:17:38","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("179","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:18:54","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("180","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:19:36","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("181","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:22:25","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("182","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:22:50","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("183","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:23:31","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("184","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:23:32","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("185","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:23:54","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("186","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:24:11","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("187","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:24:13","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("188","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:30:12","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("189","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:30:13","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("190","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:30:14","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("191","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:33:37","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("192","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:33:39","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("193","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:33:40","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("194","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:35:20","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("195","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:35:22","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("196","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:37:31","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("197","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:37:32","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("198","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 02:39:21","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("199","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 02:46:37","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("200","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 02:48:02","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("201","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 02:50:23","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("202","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 02:51:07","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("203","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 02:51:40","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("204","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 02:51:57","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("205","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-08 02:58:20","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("206","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-08 02:58:37","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("207","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-08 03:00:06","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("208","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-08 03:02:35","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("209","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:03:00","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("210","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:03:50","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("211","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:04:06","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("212","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:05:08","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("213","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:05:28","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("214","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:05:39","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("215","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:05:48","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("216","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:06:00","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("217","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:10:07","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("218","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:10:11","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("219","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:13:54","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("220","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:16:23","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("221","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:17:26","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("222","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:18:30","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("223","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:18:49","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("224","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:19:57","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("225","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:20:23","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("226","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:21:00","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("227","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-08 03:21:16","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("228","1","editar","Edición de rendición","10","rendicion","2025-03-08 03:42:56","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("229","1","crear","Creación de rendición","11","rendicion","2025-03-08 03:44:08","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("230","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-08 15:06:26","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("231","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-08 23:58:12","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("232","1","crear","Creación de repuesto","1","repuesto","2025-03-09 00:13:48","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("233","1","editar","Edición de repuesto","1","repuesto","2025-03-09 00:14:06","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("234","1","crear","Creación de máquina","1","maquina","2025-03-09 00:16:02","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("235","1","editar","Edición de máquina","1","maquina","2025-03-09 00:16:36","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("246","1","crear","Creación de solicitud de repuestos","11","solicitud_repuesto","2025-03-09 00:57:42","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("247","1","aprobar","Aprobación de solicitud de repuestos","11","solicitud_repuesto","2025-03-09 00:57:52","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("248","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-09 01:05:48","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("249","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-09 01:10:52","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("250","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-09 01:12:22","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("251","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-09 01:12:23","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("252","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-09 01:12:23","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("253","2","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-09 01:17:46","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("254","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:20:02","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("255","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:20:26","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("258","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:25:57","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("259","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:26:03","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("260","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:26:52","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("261","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:29:44","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("262","2","crear","Creación de solicitud de repuestos","12","solicitud_repuesto","2025-03-09 01:30:42","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("263","2","eliminar","Eliminación de solicitud de repuestos","12","solicitud_repuesto","2025-03-09 01:30:45","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("264","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:31:05","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("265","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:31:15","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("266","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:31:23","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("267","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:42:06","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("268","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:42:24","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("269","1","desactivar","Desactivar usuario: Juan Díaz","2","usuario","2025-03-09 01:42:45","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("270","1","activar","Activar usuario: Juan Díaz","2","usuario","2025-03-09 01:42:59","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("271","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:43:25","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("272","2","logout","Salir de la cuenta",NULL,NULL,"2025-03-09 01:43:37","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("273","2","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-09 01:44:21","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("274","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:44:48","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("275","2","logout","Salir de la cuenta",NULL,NULL,"2025-03-09 01:45:02","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("276","2","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-09 01:45:12","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("277","1","editar","Edición de usuario: Juan Díaz","2","usuario","2025-03-09 01:45:52","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("278","2","logout","Salir de la cuenta",NULL,NULL,"2025-03-09 01:45:57","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("279","2","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-09 01:46:00","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("280","2","logout","Salir de la cuenta",NULL,NULL,"2025-03-09 01:48:24","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("281","3","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-09 01:48:34","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("282","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-09 17:36:56","181.43.224.168");
INSERT INTO `historial_cambios` VALUES ("283","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-09 20:35:25","190.160.43.26");
INSERT INTO `historial_cambios` VALUES ("284","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-10 08:55:24","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("285","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-10 09:13:19","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("286","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-10 09:13:19","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("287","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-10 09:58:42","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("288","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-10 09:58:59","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("289","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-10 10:01:50","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("290","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-10 10:01:50","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("291","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-10 12:51:41","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("292","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-10 12:51:46","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("293","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-10 12:51:47","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("294","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-10 12:52:18","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("295","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-10 12:52:19","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("296","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-10 13:49:02","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("297","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-10 13:50:15","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("298","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-10 13:50:15","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("299","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-10 14:12:28","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("300","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-10 14:12:29","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("301","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-10 14:16:26","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("302","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-10 14:16:27","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("303","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-10 17:11:56","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("304","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-10 22:07:12","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("305","1","crear","Creación de solicitud de repuestos","13","solicitud_repuesto","2025-03-11 00:00:19","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("306","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-11 00:00:29","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("307","1","editar","Edición de solicitud de repuestos","13","solicitud_repuesto","2025-03-11 00:00:37","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("308","1","editar","Edición de solicitud de repuestos","13","solicitud_repuesto","2025-03-11 00:00:59","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("309","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-11 08:57:09","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("310","1","editar","Edición de máquina","1","maquina","2025-03-11 09:38:30","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("311","1","editar","Edición de repuesto","1","repuesto","2025-03-11 09:47:02","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("312","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-11 09:56:26","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("313","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-11 09:56:26","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("314","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-11 09:56:46","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("315","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-11 09:56:46","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("316","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-11 10:00:11","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("317","1","descargar","Descarga de PDF de solicitud: SOL-2025-011","11","solicitud_repuesto","2025-03-11 10:00:12","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("318","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-11 11:13:26","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("319","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-11 11:13:26","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("320","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-11 11:14:03","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("321","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-11 11:14:29","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("322","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-11 11:14:42","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("323","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-11 11:19:47","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("324","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-11 11:21:49","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("325","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-11 11:22:20","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("326","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-11 11:22:32","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("327","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-11 11:22:44","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("328","1","descargar","Descarga de PDF: OC-2025-005","5","orden_compra","2025-03-11 11:22:58","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("329","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-11 12:57:38","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("330","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-11 12:57:39","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("331","1","crear","Creación de solicitud de repuestos","14","solicitud_repuesto","2025-03-11 13:23:07","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("332","1","aprobar","Aprobación de solicitud de repuestos","14","solicitud_repuesto","2025-03-11 13:23:22","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("333","1","descargar","Descarga de PDF de solicitud: SOL-2025-014","14","solicitud_repuesto","2025-03-11 13:23:23","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("334","1","descargar","Descarga de PDF de solicitud: SOL-2025-014","14","solicitud_repuesto","2025-03-11 13:23:24","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("335","1","descargar","Descarga de PDF de solicitud: SOL-2025-014","14","solicitud_repuesto","2025-03-11 13:56:40","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("336","1","descargar","Descarga de PDF de solicitud: SOL-2025-014","14","solicitud_repuesto","2025-03-11 13:56:41","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("337","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-11 18:00:52","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("338","1","crear","Creación de máquina","2","maquina","2025-03-11 18:08:35","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("339","1","editar","Edición de máquina","2","maquina","2025-03-11 18:08:59","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("340","1","crear","Creación de solicitud de repuestos","15","solicitud_repuesto","2025-03-11 18:16:51","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("341","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-12 13:20:02","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("342","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-12 14:41:05","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("343","1","crear","Creación de orden de compra","11","orden_compra","2025-03-12 15:17:54","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("344","1","editar","Edición de orden de compra","11","orden_compra","2025-03-12 15:28:13","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("345","1","editar","Edición de orden de compra","11","orden_compra","2025-03-12 15:28:54","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("346","1","editar","Edición de orden de compra","11","orden_compra","2025-03-12 15:43:20","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("347","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-12 15:50:08","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("348","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-12 15:50:09","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("349","1","editar","Edición de orden de compra","11","orden_compra","2025-03-12 15:50:35","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("350","1","aprobar","Aprobación de orden de compra","11","orden_compra","2025-03-12 15:50:40","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("351","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:50:42","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("352","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:50:43","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("353","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:51:41","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("354","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:52:30","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("355","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:53:03","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("356","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:53:26","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("357","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:53:47","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("358","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:55:38","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("359","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:56:00","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("360","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:56:24","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("361","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:56:29","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("362","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:57:25","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("363","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:59:18","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("364","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 15:59:48","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("365","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:00:21","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("366","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:00:25","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("367","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:01:33","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("368","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:02:37","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("369","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:05:51","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("370","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:06:13","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("371","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:06:33","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("372","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:21:08","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("373","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:21:16","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("374","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:21:16","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("375","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:21:17","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("376","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:21:17","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("377","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:21:18","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("378","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:21:18","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("379","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:21:19","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("380","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:21:19","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("381","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:21:19","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("382","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:21:20","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("383","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:21:20","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("384","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-12 16:21:42","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("385","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-12 16:21:42","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("386","1","descargar","Descarga de PDF: REN-2025-008","8","rendicion","2025-03-12 16:25:27","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("387","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-12 16:25:32","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("388","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-12 16:25:33","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("389","1","descargar","Descarga de PDF: OC-2025-010","10","orden_compra","2025-03-12 16:25:54","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("390","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:25:56","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("391","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:25:57","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("392","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:26:00","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("393","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:26:03","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("394","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:26:04","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("395","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:26:05","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("396","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:26:06","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("397","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:26:11","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("398","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:26:11","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("399","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:26:48","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("400","1","descargar","Descarga de PDF: OC-2025-011","11","orden_compra","2025-03-12 16:41:51","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("401","1","logout","Salir de la cuenta",NULL,NULL,"2025-03-12 17:13:27","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("402","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-12 17:14:16","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("403","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-12 17:54:12","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("404","1","crear","Creación de repuesto","2","repuesto","2025-03-12 17:55:31","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("405","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-12 18:51:11","186.10.128.38");
INSERT INTO `historial_cambios` VALUES ("406","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-12 22:36:40","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("407","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-12 23:13:25","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("408","1","editar","Edición de repuesto","2","repuesto","2025-03-12 23:13:34","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("409","1","editar","Edición de repuesto","1","repuesto","2025-03-13 00:19:13","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("410","1","editar","Edición de máquina","2","maquina","2025-03-13 00:19:47","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("411","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 1",NULL,"sistema","2025-03-13 00:37:07","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("412","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 00:37:07","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("413","1","editar","Edición de repuesto","1","repuesto","2025-03-13 00:37:36","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("414","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 00:37:39","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("415","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 00:37:39","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("416","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 00:37:42","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("417","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 00:37:42","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("418","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-13 08:55:37","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("419","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-13 09:02:30","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("420","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 09:03:16","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("421","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 09:03:16","190.22.133.186");
INSERT INTO `historial_cambios` VALUES ("422","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 09:21:50","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("423","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 09:21:50","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("424","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-13 12:16:48","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("425","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 12:22:53","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("426","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 12:22:53","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("427","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 12:23:11","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("428","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 12:23:11","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("429","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 12:58:56","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("430","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 12:58:56","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("431","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-13 15:18:09","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("432","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 15:23:43","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("433","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 15:23:43","201.236.190.215");
INSERT INTO `historial_cambios` VALUES ("434","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 15:31:04","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("435","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 15:31:04","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("436","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-13 16:26:17","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("437","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 16:26:26","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("438","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 16:26:26","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("439","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 16:33:04","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("440","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 16:33:04","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("441","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 16:33:18","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("442","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 16:33:18","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("443","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 16:36:45","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("444","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 16:36:45","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("445","1","sistema","Actualización de stock desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 16:36:49","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("446","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 16:36:49","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("447","1","sistema","ActualizaciÃ³n automÃ¡tica desde Softland. Repuestos actualizados: 1",NULL,"sistema","2025-03-13 16:47:00","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("448","1","sistema","ActualizaciÃ³n automÃ¡tica desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 16:47:37","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("449","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-13 17:44:58","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("450","1","sistema","ActualizaciÃ³n automÃ¡tica desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 17:45:13","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("451","1","sistema","ActualizaciÃ³n automÃ¡tica desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 17:51:00","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("452","1","sistema","Actualización automática desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-13 20:59:14","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("453","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-13 17:59:14","186.11.72.196");
INSERT INTO `historial_cambios` VALUES ("454","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-14 00:01:21","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("455","1","sistema","Actualización automática desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-14 03:01:38","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("456","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-14 00:01:38","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("457","1","sistema","Actualización automática desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-14 04:34:15","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("458","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-14 01:34:15","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("468","1","editar","Edición de máquina","1","maquina","2025-03-14 03:15:54","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("469","1","editar","Edición de máquina","2","maquina","2025-03-14 03:16:08","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("470","1","sistema","Actualización automática desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-14 06:16:36","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("471","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-14 03:16:36","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("472","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-14 11:43:56","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("473","1","sistema","Actualización automática desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-14 14:44:11","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("474","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-14 11:44:11","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("475","1","crear","Creación de repuesto","3","repuesto","2025-03-14 11:47:45","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("476","1","sistema","Actualización automática desde Softland. Repuestos actualizados: 1",NULL,"sistema","2025-03-14 14:47:56","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("477","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-14 11:47:56","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("478","1","sistema","Actualización automática desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-14 14:48:02","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("479","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-14 11:48:02","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("480","1","editar","Edición de máquina","1","maquina","2025-03-14 11:50:04","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("481","1","descargar","Descarga de PDF de solicitud: SOL-2025-014","14","solicitud_repuesto","2025-03-14 11:51:30","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("482","1","editar","Edición de máquina","1","maquina","2025-03-14 11:53:28","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("483","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-14 23:07:51","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("491","1","editar","Edición de máquina","1","maquina","2025-03-14 23:19:32","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("492","1","editar","Edición de repuesto","3","repuesto","2025-03-14 23:48:20","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("493","1","editar","Edición de repuesto","3","repuesto","2025-03-14 23:55:19","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("494","1","editar","Edición de repuesto","2","repuesto","2025-03-14 23:55:22","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("495","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-15 00:43:39","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("496","1","editar","Edición de máquina","1","maquina","2025-03-15 01:46:22","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("497","1","editar","Edición de repuesto","3","repuesto","2025-03-15 01:57:58","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("498","1","sistema","Actualización automática desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-15 04:58:11","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("499","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-15 01:58:11","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("505","1","crear","Creación de solicitud de repuestos. Detalles: Número de seguimiento: SR-202503-0016; Repuesto ID: 3, Cantidad: 2","21","solicitud_repuesto","2025-03-15 02:17:50","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("506","1","crear","Creación de solicitud de repuestos. Detalles: Número de seguimiento: SR-202503-0017; Repuesto ID: 3, Cantidad: 2","22","solicitud_repuesto","2025-03-15 02:17:50","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("507","1","crear","Creación de solicitud de repuestos. Detalles: Número de seguimiento: SR-202503-0018; Repuesto ID: 3, Cantidad: 2","23","solicitud_repuesto","2025-03-15 02:19:35","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("508","1","editar","Edición de solicitud de repuestos. Detalles: Repuesto ID: 3, Cantidad: 2","23","solicitud_repuesto","2025-03-15 02:19:59","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("509","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-16 20:59:51","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("510","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-16 21:09:29","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("511","1","sistema","Actualización automática desde Softland. Repuestos actualizados: 0",NULL,"sistema","2025-03-17 00:22:02","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("512","1","sistema","Actualización de stock desde Softland",NULL,"sistema","2025-03-16 21:22:02","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("513","1","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-16 22:12:40","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("514","2","login","Inicio de sesión exitoso",NULL,NULL,"2025-03-16 22:42:45","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("515","1","limpiar_cache","Limpieza de caché del sistema",NULL,NULL,"2025-03-16 22:49:06","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("516","1","limpiar_cache","Limpieza de caché del sistema",NULL,NULL,"2025-03-16 22:51:07","181.42.17.56");
INSERT INTO `historial_cambios` VALUES ("517","1","backup","Generación de respaldo de base de datos: backup_2025-03-17_01-52-38.sql",NULL,NULL,"2025-03-16 22:52:38","181.42.17.56");


CREATE TABLE `maquina_imagenes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `maquina_id` int(11) NOT NULL,
  `nombre_archivo` varchar(255) NOT NULL,
  `ruta_archivo` varchar(255) NOT NULL,
  `es_principal` tinyint(1) NOT NULL DEFAULT 0,
  `fecha_subida` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `maquina_id` (`maquina_id`),
  CONSTRAINT `maquina_imagenes_ibfk_1` FOREIGN KEY (`maquina_id`) REFERENCES `maquinas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `maquina_imagenes` VALUES ("1","1","maq_67cd07f2c1b5c.jpg","uploads/maquinas/maq_67cd07f2c1b5c.jpg","0","2025-03-09 00:16:02");
INSERT INTO `maquina_imagenes` VALUES ("2","1","maq_67d02ec6e8509.jpg","uploads/maquinas/maq_67d02ec6e8509.jpg","0","2025-03-11 09:38:30");
INSERT INTO `maquina_imagenes` VALUES ("3","1","maq_67d02ec6e8b52.jpg","uploads/maquinas/maq_67d02ec6e8b52.jpg","1","2025-03-11 09:38:30");


CREATE TABLE `maquina_repuesto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `maquina_id` int(11) NOT NULL,
  `repuesto_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `maquina_repuesto` (`maquina_id`,`repuesto_id`),
  KEY `repuesto_id` (`repuesto_id`),
  CONSTRAINT `maquina_repuesto_ibfk_1` FOREIGN KEY (`maquina_id`) REFERENCES `maquinas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `maquina_repuesto_ibfk_2` FOREIGN KEY (`repuesto_id`) REFERENCES `repuestos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `maquina_repuesto` VALUES ("2","1","1");
INSERT INTO `maquina_repuesto` VALUES ("10","1","3");
INSERT INTO `maquina_repuesto` VALUES ("4","2","1");
INSERT INTO `maquina_repuesto` VALUES ("8","2","2");
INSERT INTO `maquina_repuesto` VALUES ("9","2","3");


CREATE TABLE `maquinas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(50) NOT NULL,
  `nombre` varchar(200) NOT NULL,
  `descripcion` mediumtext DEFAULT NULL,
  `marca` varchar(100) DEFAULT NULL,
  `modelo` varchar(100) DEFAULT NULL,
  `numero_serie` varchar(100) DEFAULT NULL,
  `fecha_registro` datetime NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT 1,
  `serie_id` int(11) DEFAULT NULL,
  `serie_manual` varchar(50) DEFAULT NULL,
  `costo` decimal(10,2) DEFAULT NULL COMMENT 'Precio costo de la máquina',
  `estado` varchar(50) NOT NULL DEFAULT 'activo',
  PRIMARY KEY (`id`),
  UNIQUE KEY `codigo` (`codigo`),
  KEY `fk_serie_id` (`serie_id`),
  CONSTRAINT `fk_serie_id` FOREIGN KEY (`serie_id`) REFERENCES `series_maquinas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `maquinas` VALUES ("1","SHTMMMSD","PRUEBA LOCA","MAQUINA NORAM","CAFISA","CAFISA LCA","021823018312803","2025-03-09 00:16:02","1",NULL,NULL,NULL,"activo");
INSERT INTO `maquinas` VALUES ("2","601513999","E98 2 grupos","","Faema","E98 2 grupos","1682159","2025-03-11 18:08:35","1",NULL,NULL,NULL,"activo");


CREATE TABLE `motivos_devolucion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `descripcion` mediumtext DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `motivos_devolucion` VALUES ("1","Productos sin stock","Devolución por productos que no estaban disponibles en stock","1");
INSERT INTO `motivos_devolucion` VALUES ("2","Error de cobro","Devolución por error en el cobro realizado","1");
INSERT INTO `motivos_devolucion` VALUES ("3","Cancelación de compra","Devolución por cancelación de la compra completa","1");
INSERT INTO `motivos_devolucion` VALUES ("4","Otros","Otros motivos de devolución","1");


CREATE TABLE `ordenes_compra` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `proveedor` varchar(200) NOT NULL,
  `rut_proveedor` varchar(15) NOT NULL,
  `fecha` date NOT NULL,
  `descripcion` mediumtext DEFAULT NULL,
  `numero_documento` varchar(50) NOT NULL,
  `monto_total` decimal(15,2) NOT NULL DEFAULT 0.00,
  `estado_id` int(11) NOT NULL,
  `revisor_id` int(11) DEFAULT NULL,
  `comentario_revision` mediumtext DEFAULT NULL,
  `fecha_revision` datetime DEFAULT NULL,
  `fecha_creacion` datetime NOT NULL,
  `ultima_modificacion` datetime NOT NULL,
  `condiciones_pago` varchar(255) DEFAULT NULL,
  `proveedor_id` int(11) DEFAULT NULL,
  `direccion_despacho` varchar(255) DEFAULT NULL,
  `motivo_orden` varchar(50) DEFAULT NULL,
  `area_solicitud` enum('bodega','servicio_tecnico','tiendas','otros') DEFAULT NULL,
  `tiempo_entrega` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `estado_id` (`estado_id`),
  KEY `revisor_id` (`revisor_id`),
  KEY `ordenes_compra_ibfk_4` (`proveedor_id`),
  CONSTRAINT `ordenes_compra_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `ordenes_compra_ibfk_2` FOREIGN KEY (`estado_id`) REFERENCES `estados` (`id`),
  CONSTRAINT `ordenes_compra_ibfk_3` FOREIGN KEY (`revisor_id`) REFERENCES `users` (`id`),
  CONSTRAINT `ordenes_compra_ibfk_4` FOREIGN KEY (`proveedor_id`) REFERENCES `proveedores` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ordenes_compra` VALUES ("5","1","Proveedor de Pruena","26.058.798-6","2025-03-07","","010000","25000.00","3","1","","2025-03-07 14:30:37","2025-03-07 12:58:27","2025-03-07 12:58:27","",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `ordenes_compra` VALUES ("6","1","COMEMOS SPA","26.058.798-6","2025-03-08","DESCE","0001","20000.00","1",NULL,NULL,NULL,"2025-03-07 22:09:16","2025-03-07 22:09:16","30 dias","1",NULL,NULL,NULL,NULL);
INSERT INTO `ordenes_compra` VALUES ("9","1","COMEMOS SPA","26.058.798-6","2025-03-08","","000111","64000.00","1",NULL,NULL,NULL,"2025-03-07 22:21:51","2025-03-07 22:22:14","","1",NULL,NULL,NULL,NULL);
INSERT INTO `ordenes_compra` VALUES ("10","4","COMEMOS SPA","26.058.798-6","2025-03-08","","01333","649500.00","3","1","","2025-03-08 00:45:05","2025-03-07 22:23:32","2025-03-07 22:23:32","","1",NULL,NULL,NULL,NULL);
INSERT INTO `ordenes_compra` VALUES ("11","1","COMEMOS SPA","26.058.798-6","2025-03-12","","2024","108200.00","3","1","","2025-03-12 15:50:40","2025-03-12 15:17:54","2025-03-12 15:50:35","30 dias","1","Bodega Principal - Lira 1133, Santiago","Para cotización","servicio_tecnico","2 días");


CREATE TABLE `origenes_devolucion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `descripcion` mediumtext DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `origenes_devolucion` VALUES ("1","Compra web","Devolución por compra realizada en tienda en línea","1");
INSERT INTO `origenes_devolucion` VALUES ("2","Compra en tienda","Devolución por compra realizada en tienda física","1");
INSERT INTO `origenes_devolucion` VALUES ("3","Otros","Otros orígenes de devolución","1");


CREATE TABLE `permisos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `permisos` VALUES ("1","crear_rendicion","Permiso para crear rendiciones de gastos");
INSERT INTO `permisos` VALUES ("2","editar_rendicion","Permiso para editar rendiciones de gastos");
INSERT INTO `permisos` VALUES ("3","ver_rendiciones","Permiso para ver rendiciones");
INSERT INTO `permisos` VALUES ("4","aprobar_rendiciones","Permiso para aprobar o rechazar rendiciones");
INSERT INTO `permisos` VALUES ("5","crear_nota_venta","Permiso para crear notas de venta");
INSERT INTO `permisos` VALUES ("6","editar_nota_venta","Permiso para editar notas de venta");
INSERT INTO `permisos` VALUES ("7","ver_notas_venta","Permiso para ver notas de venta");
INSERT INTO `permisos` VALUES ("8","aprobar_notas_venta","Permiso para aprobar o rechazar notas de venta");
INSERT INTO `permisos` VALUES ("9","gestionar_usuarios","Permiso para gestionar usuarios");
INSERT INTO `permisos` VALUES ("10","ver_reportes","Permiso para ver reportes y estadísticas");
INSERT INTO `permisos` VALUES ("11","carga_masiva","Permiso para realizar carga masiva de datos");
INSERT INTO `permisos` VALUES ("12","crear_guia_entrada","Permiso para crear guías de entrada");
INSERT INTO `permisos` VALUES ("13","editar_guia_entrada","Permiso para editar guías de entrada");
INSERT INTO `permisos` VALUES ("14","ver_guias_entrada","Permiso para ver guías de entrada propias");
INSERT INTO `permisos` VALUES ("15","ver_todas_guias","Permiso para ver todas las guías de entrada");
INSERT INTO `permisos` VALUES ("16","aprobar_guias_entrada","Permiso para aprobar o rechazar guías de entrada");
INSERT INTO `permisos` VALUES ("17","crear_orden_compra","Permiso para crear órdenes de compra");
INSERT INTO `permisos` VALUES ("18","editar_orden_compra","Permiso para editar órdenes de compra");
INSERT INTO `permisos` VALUES ("19","ver_ordenes_compra","Permiso para ver órdenes de compra");
INSERT INTO `permisos` VALUES ("20","aprobar_ordenes_compra","Permiso para aprobar o rechazar órdenes de compra");
INSERT INTO `permisos` VALUES ("21","ver_maquinas","Permiso para ver máquinas");
INSERT INTO `permisos` VALUES ("22","crear_maquina","Permiso para crear máquinas");
INSERT INTO `permisos` VALUES ("23","editar_maquina","Permiso para editar máquinas");
INSERT INTO `permisos` VALUES ("24","ver_repuestos","Permiso para ver repuestos");
INSERT INTO `permisos` VALUES ("25","crear_repuesto","Permiso para crear repuestos");
INSERT INTO `permisos` VALUES ("26","editar_repuesto","Permiso para editar repuestos");
INSERT INTO `permisos` VALUES ("27","crear_solicitud_repuesto","Permiso para crear solicitudes de repuestos");
INSERT INTO `permisos` VALUES ("28","editar_solicitud_repuesto","Permiso para editar solicitudes de repuestos");
INSERT INTO `permisos` VALUES ("29","ver_solicitudes_repuesto","Permiso para ver solicitudes de repuestos");
INSERT INTO `permisos` VALUES ("30","aprobar_solicitudes_repuesto","Permiso para aprobar solicitudes de repuestos");
INSERT INTO `permisos` VALUES ("31","crear_devolucion","Permiso para crear devoluciones");
INSERT INTO `permisos` VALUES ("32","editar_devolucion","Permiso para editar devoluciones");
INSERT INTO `permisos` VALUES ("33","ver_devoluciones","Permiso para ver devoluciones");
INSERT INTO `permisos` VALUES ("34","aprobar_devoluciones","Permiso para aprobar o rechazar devoluciones");
INSERT INTO `permisos` VALUES ("35","acceso_admin_sistema","Permiso para acceder al módulo de administración del sistema");
INSERT INTO `permisos` VALUES ("36","limpiar_cache","Permiso para limpiar el caché del sistema");
INSERT INTO `permisos` VALUES ("37","eliminar_documentos","Permiso para eliminar documentos autorizados");
INSERT INTO `permisos` VALUES ("38","limpiar_base_datos","Permiso para ejecutar limpieza de base de datos");
INSERT INTO `permisos` VALUES ("39","ver_logs_sistema","Permiso para ver logs del sistema");
INSERT INTO `permisos` VALUES ("40","gestionar_respaldos","Permiso para gestionar respaldos del sistema");
INSERT INTO `permisos` VALUES ("41","configuracion_sistema","Permiso para modificar configuraciones del sistema");


CREATE TABLE `proveedores` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rut` varchar(15) NOT NULL,
  `nombre` varchar(200) NOT NULL,
  `direccion` varchar(255) DEFAULT NULL,
  `comuna` varchar(100) DEFAULT NULL,
  `pais` varchar(50) DEFAULT 'Chile',
  `telefono` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `contacto` varchar(100) DEFAULT NULL,
  `giro` varchar(200) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rut` (`rut`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `proveedores` VALUES ("1","26.058.798-6","COMEMOS SPA","AV LO OVALLE 4045",NULL,"Chile","956600000","COMEMOS@GMAIL.COM","LUIS ALFREDO","RESTAURANTE","1","2025-03-07 20:41:06","2025-03-07 20:41:06");


CREATE TABLE `rendicion_categoria` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rendicion_id` int(11) NOT NULL,
  `categoria_id` int(11) NOT NULL,
  `monto` decimal(15,2) NOT NULL,
  `detalle` mediumtext DEFAULT NULL,
  `tipo_documento` enum('boleta','factura','recibo','cotizacion','otro') NOT NULL DEFAULT 'otro',
  `numero_documento` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rendicion_id` (`rendicion_id`),
  KEY `categoria_id` (`categoria_id`),
  CONSTRAINT `rendicion_categoria_ibfk_1` FOREIGN KEY (`rendicion_id`) REFERENCES `rendiciones` (`id`) ON DELETE CASCADE,
  CONSTRAINT `rendicion_categoria_ibfk_2` FOREIGN KEY (`categoria_id`) REFERENCES `categorias_gastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `rendicion_categoria` VALUES ("1","1","1","150000.00","Pasajes aéreos Santiago-La Serena","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("2","1","2","85000.00","Comidas durante 2 días","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("3","1","3","121780.00","Hotel Santiago Centro","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("4","2","5","85000.00","Invitación a clientes potenciales","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("5","2","4","40000.00","Materiales promocionales","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("6","3","2","20000.00","COMPRAS COMPULSIVAS","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("7","3","4","20000.00","COMPRAS COMPULSIVAS 2","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("8","4","1","10000.00","CategorÃ­a de prueba - diagnÃ³stico","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("13","8","5","200000.00","asdasdasd","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("16","9","2","5220200.00","","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("20","10","1","200000.00","","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("21","10","3","200000.00","HOTEL EL LOCO","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("22","11","1","20000.00","","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("23","11","3","23455.00","","otro",NULL);
INSERT INTO `rendicion_categoria` VALUES ("24","11","2","23456.00","","otro",NULL);


CREATE TABLE `rendicion_soportes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rendicion_id` int(11) NOT NULL,
  `nombre_archivo` varchar(255) NOT NULL,
  `ruta_archivo` varchar(255) NOT NULL,
  `fecha_subida` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rendicion_id` (`rendicion_id`),
  CONSTRAINT `rendicion_soportes_ibfk_1` FOREIGN KEY (`rendicion_id`) REFERENCES `rendiciones` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `rendicion_soportes` VALUES ("1","10","logo.png","upload/rendicion_10/1741416176_logo.png","2025-03-08 03:42:56");
INSERT INTO `rendicion_soportes` VALUES ("2","11","FA005372.pdf","upload/rendicion_11/1741416248_FA005372.pdf","2025-03-08 03:44:08");


CREATE TABLE `rendiciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `descripcion` mediumtext NOT NULL,
  `area_origen` enum('logistica','servicio_tecnico','marketing','ventas','comercial','operaciones','finanzas','otra') NOT NULL DEFAULT 'otra',
  `fecha` date NOT NULL,
  `monto_total` decimal(15,2) NOT NULL DEFAULT 0.00,
  `estado_id` int(11) NOT NULL,
  `revisor_id` int(11) DEFAULT NULL,
  `comentario_revision` mediumtext DEFAULT NULL,
  `fecha_revision` datetime DEFAULT NULL,
  `fecha_creacion` datetime NOT NULL,
  `ultima_modificacion` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `estado_id` (`estado_id`),
  KEY `revisor_id` (`revisor_id`),
  CONSTRAINT `rendiciones_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `rendiciones_ibfk_2` FOREIGN KEY (`estado_id`) REFERENCES `estados` (`id`),
  CONSTRAINT `rendiciones_ibfk_3` FOREIGN KEY (`revisor_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `rendiciones` VALUES ("1","2","Viaje a Santiago para reunión con cliente","otra","2024-02-15","356780.00","3","1","","2025-03-06 13:17:20","2024-02-16 10:30:00","2024-02-16 10:30:00");
INSERT INTO `rendiciones` VALUES ("2","2","Gastos de representación Feria Internacional","otra","2024-01-25","125000.00","3",NULL,NULL,NULL,"2024-01-26 14:45:00","2024-01-28 09:20:00");
INSERT INTO `rendiciones` VALUES ("3","1","GASTOS ENERO 2024","otra","2025-03-06","40000.00","3","1","","2025-03-06 13:17:26","2025-03-06 12:31:20","2025-03-06 12:31:20");
INSERT INTO `rendiciones` VALUES ("4","1","PRUEBA DE DIAGNÃ“STICO - 2025-03-07 14:06:58","otra","2025-03-07","10000.00","1",NULL,NULL,NULL,"2025-03-07 11:06:58","2025-03-07 11:06:58");
INSERT INTO `rendiciones` VALUES ("8","1","GASTOS ENERO 2024 2525","otra","2025-03-07","200000.00","3","1","","2025-03-07 12:43:03","2025-03-07 12:42:12","2025-03-07 12:42:44");
INSERT INTO `rendiciones` VALUES ("9","1","Hola","otra","2025-03-07","5220200.00","1",NULL,NULL,NULL,"2025-03-07 16:40:58","2025-03-07 16:40:58");
INSERT INTO `rendiciones` VALUES ("10","4","Gastos de viaje a santiago","otra","2025-03-08","400000.00","1",NULL,NULL,NULL,"2025-03-07 21:51:02","2025-03-08 03:42:56");
INSERT INTO `rendiciones` VALUES ("11","1","GASTOS MES DE OCTUBRE","otra","2025-03-08","66911.00","1",NULL,NULL,NULL,"2025-03-08 03:44:08","2025-03-08 03:44:08");


CREATE TABLE `repuestos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(50) NOT NULL,
  `nombre` varchar(200) NOT NULL,
  `descripcion` mediumtext DEFAULT NULL,
  `categoria_id` int(11) DEFAULT NULL,
  `numero_pieza` varchar(100) DEFAULT NULL,
  `codigo_pieza` varchar(50) DEFAULT NULL,
  `costo` decimal(15,2) DEFAULT NULL,
  `disponible` tinyint(1) NOT NULL DEFAULT 1,
  `stock` int(11) DEFAULT 0,
  `fecha_registro` datetime NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT 1,
  `ubicacion` varchar(100) DEFAULT NULL COMMENT 'Código de barras del producto en Softland',
  `codigo_proveedor` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `codigo` (`codigo`),
  KEY `categoria_id` (`categoria_id`),
  CONSTRAINT `repuestos_ibfk_1` FOREIGN KEY (`categoria_id`) REFERENCES `categorias_repuestos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `repuestos` VALUES ("1","SHFABDA","Mangera Negra Corta","",NULL,"10",NULL,"20000.00","0","0","2025-03-09 00:13:48","1","",NULL);
INSERT INTO `repuestos` VALUES ("2","802114801","REP NR MON - PISTON DEL GRIFO","",NULL,"25","","25000.00","1","10","2025-03-12 17:55:31","1","F2280014801 - UB-31-C-3-4","");
INSERT INTO `repuestos` VALUES ("3","801395025","CUALQUIERA","",NULL,"","",NULL,"1","20","2025-03-14 11:47:45","1","REP-SPINEL-TERMOSTATO DE SEGURIDAD GRUPO","");


CREATE TABLE `series_maquinas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo_serie` varchar(50) NOT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  `activo` tinyint(1) DEFAULT 1,
  `fecha_inicio` datetime DEFAULT NULL,
  `fecha_inicio_estado` datetime DEFAULT NULL,
  `maquina_id` int(11) NOT NULL,
  `estado` varchar(50) NOT NULL DEFAULT 'activo',
  `proveedor_id` int(11) DEFAULT NULL,
  `cliente_id` int(11) DEFAULT NULL,
  `historial_estados` text DEFAULT NULL COMMENT 'Historial de estados en formato JSON',
  PRIMARY KEY (`id`),
  UNIQUE KEY `codigo_serie` (`codigo_serie`),
  KEY `series_maquinas_ibfk_1` (`maquina_id`),
  KEY `series_maquinas_proveedor_id_fk` (`proveedor_id`),
  CONSTRAINT `series_maquinas_ibfk_1` FOREIGN KEY (`maquina_id`) REFERENCES `maquinas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `series_maquinas_proveedor_id_fk` FOREIGN KEY (`proveedor_id`) REFERENCES `proveedores` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `series_maquinas` VALUES ("2","011123123",NULL,"1","2025-03-06 00:00:00","2025-03-15 04:46:22","1","comodato","1",NULL,"[{\"estado\":\"comodato\",\"fecha\":\"2025-03-15 04:46:22\",\"usuario_id\":1,\"cliente_id\":null,\"proveedor_id\":\"1\"}]");
INSERT INTO `series_maquinas` VALUES ("3","132213124",NULL,"1",NULL,"2025-03-15 04:46:22","1","nueva",NULL,NULL,"[{\"estado\":\"nueva\",\"fecha\":\"2025-03-15 04:46:22\",\"usuario_id\":1,\"cliente_id\":null,\"proveedor_id\":null}]");


CREATE TABLE `solicitud_repuesto_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `solicitud_id` int(11) NOT NULL,
  `repuesto_id` int(11) NOT NULL,
  `cantidad` int(11) NOT NULL,
  `codigo_proveedor` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `solicitud_id` (`solicitud_id`),
  KEY `repuesto_id` (`repuesto_id`),
  CONSTRAINT `solicitud_repuesto_detalle_ibfk_1` FOREIGN KEY (`solicitud_id`) REFERENCES `solicitud_repuestos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `solicitud_repuesto_detalle_ibfk_2` FOREIGN KEY (`repuesto_id`) REFERENCES `repuestos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `solicitud_repuesto_detalle` VALUES ("11","11","1","1",NULL);
INSERT INTO `solicitud_repuesto_detalle` VALUES ("15","13","1","1","01012");
INSERT INTO `solicitud_repuesto_detalle` VALUES ("16","14","1","2","0111");
INSERT INTO `solicitud_repuesto_detalle` VALUES ("17","15","1","1",NULL);
INSERT INTO `solicitud_repuesto_detalle` VALUES ("18","21","3","2",NULL);
INSERT INTO `solicitud_repuesto_detalle` VALUES ("19","22","3","2",NULL);
INSERT INTO `solicitud_repuesto_detalle` VALUES ("21","23","3","2","");


CREATE TABLE `solicitud_repuestos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `numero_seguimiento` varchar(20) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `maquina_id` int(11) NOT NULL,
  `serie_id` int(11) DEFAULT NULL COMMENT 'ID de la serie específica de la máquina',
  `descripcion` mediumtext NOT NULL,
  `fecha` date NOT NULL,
  `estado_id` int(11) NOT NULL,
  `revisor_id` int(11) DEFAULT NULL,
  `comentario_revision` mediumtext DEFAULT NULL,
  `fecha_revision` datetime DEFAULT NULL,
  `fecha_creacion` datetime NOT NULL,
  `ultima_modificacion` datetime NOT NULL,
  `area_origen` enum('servicio_tecnico','bodega','ventas','otra') NOT NULL,
  `motivo_solicitud` enum('maquinas_comodato','presupuestos','ordenes_compra','rebaja_inventario','otro') NOT NULL,
  `cliente_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `maquina_id` (`maquina_id`),
  KEY `estado_id` (`estado_id`),
  KEY `revisor_id` (`revisor_id`),
  KEY `idx_numero_seguimiento` (`numero_seguimiento`),
  KEY `fk_solicitud_cliente` (`cliente_id`),
  CONSTRAINT `fk_solicitud_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `proveedores` (`id`),
  CONSTRAINT `solicitud_repuestos_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `solicitud_repuestos_ibfk_2` FOREIGN KEY (`maquina_id`) REFERENCES `maquinas` (`id`),
  CONSTRAINT `solicitud_repuestos_ibfk_3` FOREIGN KEY (`estado_id`) REFERENCES `estados` (`id`),
  CONSTRAINT `solicitud_repuestos_ibfk_4` FOREIGN KEY (`revisor_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `solicitud_repuestos` VALUES ("11","SR-202503-0011","1","1",NULL,"asdasda","2025-03-09","3","1","","2025-03-09 00:57:52","2025-03-09 00:57:42","2025-03-09 00:57:42","servicio_tecnico","maquinas_comodato",NULL);
INSERT INTO `solicitud_repuestos` VALUES ("13","SR-202503-0013","1","1",NULL,"PIEZAS","2025-03-11","1",NULL,NULL,NULL,"2025-03-11 00:00:19","2025-03-11 00:00:59","servicio_tecnico","presupuestos",NULL);
INSERT INTO `solicitud_repuestos` VALUES ("14","SR-202503-0014","1","1",NULL,"Pueba","2025-03-11","3","1","","2025-03-11 13:23:22","2025-03-11 13:23:07","2025-03-11 13:23:07","servicio_tecnico","maquinas_comodato",NULL);
INSERT INTO `solicitud_repuestos` VALUES ("15","SR-202503-0015","1","2",NULL,"Reparación en terreno","2025-03-11","1",NULL,NULL,NULL,"2025-03-11 18:16:51","2025-03-11 18:16:51","servicio_tecnico","maquinas_comodato",NULL);
INSERT INTO `solicitud_repuestos` VALUES ("21","SR-202503-0016","1","1","2","ssss","2025-03-15","1",NULL,NULL,NULL,"2025-03-15 02:17:50","2025-03-15 02:17:50","servicio_tecnico","maquinas_comodato",NULL);
INSERT INTO `solicitud_repuestos` VALUES ("22","SR-202503-0017","1","1","2","ssss","2025-03-15","1",NULL,NULL,NULL,"2025-03-15 02:17:50","2025-03-15 02:17:50","servicio_tecnico","maquinas_comodato",NULL);
INSERT INTO `solicitud_repuestos` VALUES ("23","SR-202503-0018","1","1","2","hoal","2025-03-15","1",NULL,NULL,NULL,"2025-03-15 02:19:35","2025-03-15 02:19:59","servicio_tecnico","maquinas_comodato","1");


CREATE TABLE `user_permisos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `permiso_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_permiso` (`user_id`,`permiso_id`),
  KEY `permiso_id` (`permiso_id`),
  CONSTRAINT `user_permisos_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `user_permisos_ibfk_2` FOREIGN KEY (`permiso_id`) REFERENCES `permisos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=222 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `user_permisos` VALUES ("55","1","1");
INSERT INTO `user_permisos` VALUES ("56","1","2");
INSERT INTO `user_permisos` VALUES ("57","1","3");
INSERT INTO `user_permisos` VALUES ("58","1","4");
INSERT INTO `user_permisos` VALUES ("61","1","9");
INSERT INTO `user_permisos` VALUES ("62","1","10");
INSERT INTO `user_permisos` VALUES ("63","1","11");
INSERT INTO `user_permisos` VALUES ("59","1","17");
INSERT INTO `user_permisos` VALUES ("60","1","18");
INSERT INTO `user_permisos` VALUES ("208","1","31");
INSERT INTO `user_permisos` VALUES ("209","1","32");
INSERT INTO `user_permisos` VALUES ("210","1","33");
INSERT INTO `user_permisos` VALUES ("211","1","34");
INSERT INTO `user_permisos` VALUES ("215","1","35");
INSERT INTO `user_permisos` VALUES ("216","1","36");
INSERT INTO `user_permisos` VALUES ("217","1","37");
INSERT INTO `user_permisos` VALUES ("218","1","38");
INSERT INTO `user_permisos` VALUES ("219","1","39");
INSERT INTO `user_permisos` VALUES ("220","1","40");
INSERT INTO `user_permisos` VALUES ("221","1","41");
INSERT INTO `user_permisos` VALUES ("199","2","1");
INSERT INTO `user_permisos` VALUES ("200","2","2");
INSERT INTO `user_permisos` VALUES ("201","2","3");
INSERT INTO `user_permisos` VALUES ("202","2","17");
INSERT INTO `user_permisos` VALUES ("203","2","18");
INSERT INTO `user_permisos` VALUES ("204","2","21");
INSERT INTO `user_permisos` VALUES ("205","2","24");
INSERT INTO `user_permisos` VALUES ("206","2","27");
INSERT INTO `user_permisos` VALUES ("207","2","29");
INSERT INTO `user_permisos` VALUES ("51","4","1");
INSERT INTO `user_permisos` VALUES ("52","4","3");
INSERT INTO `user_permisos` VALUES ("54","4","10");
INSERT INTO `user_permisos` VALUES ("53","4","17");


CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rut` varchar(15) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `apellido` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `telefono` varchar(20) DEFAULT NULL,
  `cargo` varchar(100) NOT NULL,
  `rol` enum('super_admin','admin','usuario') NOT NULL DEFAULT 'usuario',
  `activo` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rut` (`rut`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `users` VALUES ("1","11.111.111-1","Jonathan","López","admin@sisrendiciones.cl","$2y$10$Kl.yO/x/Je7cR.RL4U9IMepmv031zCQLroXOq9e.FhrDnHXIZFyCC","+56912345678","Administrador del Sistema","super_admin","1","2025-03-06 07:18:04","2025-03-08 00:23:37");
INSERT INTO `users` VALUES ("2","24.156.862-8","Juan","Díaz","juan.diaz@empresa.cl","$2y$10$a2JKgz5OPbP5vv.GKJyO2OkMRqJ6mcScvqFuJfrNsYDf35zZRkQw.","+56987654321","Vendedor","usuario","1","2025-03-06 07:18:04","2025-03-09 01:45:52");
INSERT INTO `users` VALUES ("3","15.894.303-4","Jimmy","Jimenez","jimmy.jimenez@santavictoria.cl","$2y$10$LQkAgy3KSu.4/bczGs3FD.HNpMEgU3f2sMcOMLSRhYOztrq5Bldp6","","Contador","admin","1","2025-03-06 12:49:30","2025-03-06 12:49:30");
INSERT INTO `users` VALUES ("4","26.481.587-8","Alejandró","Delgado","prueba@gmail.com","$2y$10$o9Dw5bEL7TLvPWwYb67RGOlUELhBA/kKb0W1DP4jvUlQtMkt9qKbG","0000000000","Tecnico","usuario","1","2025-03-07 21:20:16","2025-03-07 21:53:25");


SET FOREIGN_KEY_CHECKS=1;